/* -*- C++ -*- */
#ifndef TESTUI_APP_H
#define TESTUI_APP_H

#include <kmainwindow.h>
#include <kparts/part.h>
#include <kactionclasses.h>
#include <libept/kde_terminal_interface.h>
#include <apt-front/cache/observer.h>
#include <apt-front/cache/component/state.h>
#include <apt-front/cache/component/history.h>
#include <libept/view.h>
#include <libept/dpkgpm-gui.h> // EWW
#include <libept/sourceseditor.h>

class QVBox;
class QWidgetStack;
class QSplitter;
class KAction;
namespace ept {
class AcqProgressWidget;
}

using namespace aptFront;

class TestApp : public KMainWindow, cache::Observer {
    Q_OBJECT
public:
    void setupActions();
    ExtTerminalInterface *terminal();
	TestApp();
protected slots:
    void update();
    void upgrade();
    void distUpgrade();
    void commit();
    // void updateListerActions( ept::Lister * );
    void listerAction();
    void foregroundClosed();
    void delayed();
    void loadKonsole();
    void setActionsEnabled( bool );
    void undo();
    void redo();
    void checkpoint();
    void setHistoryEnabled( bool );
    void preview();
    void closePreview();
    void sources();
    void closeSources();
    bool previewActive() {
        return m_previewAction->isChecked();
    }
    bool sourcesActive() {
        return m_sourcesAction->isChecked();
    }
    void closeModes() {
        closePreview();
        closeSources();
    }
protected:

    friend class WaitForLister;
    virtual void closeEvent( QCloseEvent * );
    virtual void notifyPostChange( cache::component::Base * );
    virtual void notifyPostRebuild( cache::component::Base * );
    virtual void notifyPreChange( cache::component::Base * );

    QWidgetStack *m_stack;

    // stacked widgets
    ept::AcqProgressWidget *m_progress;
    ept::View *m_list;
    ept::View *m_preview;
    KParts::Part *m_konsole;
    ept::SourcesEditor *m_sources;

    // other stuff
    ept::PkgSystem *m_pkgSystem; // bla...
    std::vector<KAction *> m_actions;
    QMap< QString, QString > m_icons;
    KAction *m_undo, *m_redo;
    cache::component::History< cache::component::State > *m_history;

    KAction *m_commit, *m_upgrade, *m_distUpgrade;
    KToggleAction *m_previewAction, *m_sourcesAction;
private:
    template<typename T> void plugAptActions();
    // template<typename T, typename In> void updateAptActions( In b, In e );
    template<typename T, typename In> void aptAction( In b, In e );
};

class WaitForLister : public QObject {
    Q_OBJECT
public:
    WaitForLister( TestApp *a, const char *s )
        : app( a ), slot( s )
        {
            waiting();
        }
protected slots:
    void waiting();
protected:
    TestApp *app;
    const char *slot;
    
};

#endif
