#include <apt-front/predicate/combinators.h>
#include <apt-front/predicate/factory.h>
#include <libept/quickfilter.h>
#include <libept/statefilter.h>
#include <libept/easytagfilter.h>
#include "view.h"

using namespace ept;

View::View( QWidget *p, const char *n )
    : QSplitter( p, n )
{
    setOrientation( Qt::Vertical );
    m_flist = new FilterList( this );
    m_lister = new Lister( this );
    m_flist->plugLister( m_lister );

    m_flist->setHiddenPredicate(
        predicate::adapt< entity::Entity >(
            predicate::Package::member( &entity::Package::hasVersion ) ) );
    m_flist->appendPredicate(
        predicate::adapt< entity::Entity >(
            StateFilter< entity::Package >() ) );
    m_flist->appendPredicate(
        predicate::adapt< entity::Entity >(
            EasyTagFilter< entity::Package >() ) );
    m_flist->appendPredicate(
        predicate::adapt< entity::Entity >(
            QuickFilter< entity::Package >() ) );
}

/* Kolik existencialistu je potreba k zasroubovani zarovky?
   Dva. Jeden sroubuje zarovku, a druhy premysli jak zarovka
   sama o sobe predstavuje jednotlivy zarivy bod v subjektivni
   realite v podsveti nekonecne absurdity dosahujici neuprimny
   vesmir nicoty. */
