#include <apt-front/predicate/combinators.h>
#include <apt-front/predicate/factory.h>
#include <klocale.h>
#include <kdebug.h>
#include <klineedit.h>
#include "quickfilter.h"

using namespace aptFront;
using namespace ept;

QuickFilterWidget::QuickFilterWidget( QWidget *parent, const char *name )
    : QuickFilterUi( parent, name )
{
    setFocusProxy( m_match );
    connect( m_match, SIGNAL( textChanged( const QString & ) ),
             this, SLOT( textChanged( const QString & ) ) );
    connect( m_reset, SIGNAL( clicked() ),
             this, SLOT( reset() ) );
    connect( &timer, SIGNAL( timeout() ),
             this, SLOT( widgetsChanged() ) );
}

void QuickFilterWidget::textChanged( const QString & )
{
    kdDebug() << "QuickFilterWidget::textChanged" << endl;
    timer.start( 400, true );
}

QuickFilterWidget::Predicate QuickFilterWidget::predicate()
{
    QuickFilter< entity::Package > f;
    f.setMatch( m_match->text().ascii() );
    return predicate::adapt< entity::Entity >( f );
}

void QuickFilterWidget::predicateChanged() {
    typedef QuickFilter< entity::Package > F;
    F f = downcast< F >( m_pred );
    m_match->blockSignals( true );
    m_match->setText( f.match() );
    m_match->blockSignals( false );
}

void QuickFilterWidget::reset() {
    m_match->setText( "" );
}

/* void QuickFilterWidget::reset() {
    m_match->clear();
    } */
