# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2007-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL.EXCEPTION" in the root of this distribution
# including a special exception to use Elisa with Fluendo's plugins and
# about affiliation parameters.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Benjamin Kampmann <benjamin@fluendo.com>


import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

setup(name='elisa-plugin-yesfm',
    version='0.0.1', 
    description='Access the content of yes.fm',
    license='GPL3', 
    author='Elisa Developers',
    author_email='elisa@lists.fluendo.com',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.png', '*.mo', '*.po', '*.conf']},
    entry_points="""
    [elisa.plugins.search.searchers]
    YesfmSearcher = elisa.plugins.yesfm.searcher:YesfmSearcher
    """,
    controller_mappings=[
                         ('/poblesec/settings/yesfm/username',
                          'elisa.plugins.poblesec.login_settings_controller:UsernameSettingsController'),
                         ('/poblesec/settings/yesfm/password',
                          'elisa.plugins.poblesec.login_settings_controller:PasswordSettingsController'),
                         ('/poblesec/settings/yesfm/login_result',
                          'elisa.plugins.poblesec.login_settings_controller:LoginResultController'),

                         ('/poblesec/yesfm/albums',
                          'elisa.plugins.yesfm.controllers:AlbumsListSwitcherController'),
                         ('/poblesec/yesfm/tracks',
                          'elisa.plugins.yesfm.controllers:TracksListSwitcherController'),
                         ('/poblesec/yesfm/track_actions',
                          'elisa.plugins.yesfm.controllers:TrackActionsController'),

                         ('/poblesec/search/results/YesfmSearcher/artists',
                          'elisa.plugins.yesfm.controllers:ArtistsListSwitcherController'),
                         ('/poblesec/search/results/YesfmSearcher/albums',
                          'elisa.plugins.yesfm.controllers:AlbumsListSwitcherController'),
                         ('/poblesec/search/results/YesfmSearcher/tracks',
                          'elisa.plugins.yesfm.controllers:TracksListSwitcherController'),
                        ],
    decorator_mappings=[
                        ('/poblesec/settings/login',
                         'elisa.plugins.yesfm.settings:yesfm_settings_decorator'),
                         ('/poblesec/database/music/albums',
                          'elisa.plugins.yesfm.library_completion:add_action_complete_albums_for_artist'),
                         ('/poblesec/database/music/tracks',
                          'elisa.plugins.yesfm.library_completion:add_action_complete_tracks_for_album'),
                       ],
    cmdclass=cmdclass
)
