import os, sys, ftplib, getpass, dputhelper

# Upload the files via ftp. (Could need a bit more error-checking.)
def upload(fqdn, login, incoming, files_to_upload, debug, ftp_mode, progress=0):
    try:
        ftp_connection = ftplib.FTP(fqdn)
        if debug:
            print "D: FTP-Connection to host: %s" % fqdn
    except ftplib.all_errors, e:
        print "Connection failed, aborting. Check your network", e
        sys.exit(1)
    prompt = login + "@" + fqdn + " password: "
    if login == 'anonymous':
        password = 'dput@packages.debian.org'
    else:
        password = getpass.getpass(prompt)
    try:
        ftp_connection.login(login,password)
    except ftplib.error_perm:
        print "Wrong Password"
        sys.exit(1)
    ftp_connection.set_pasv(ftp_mode==1)
    try:
        ftp_connection.cwd(incoming)
    except ftplib.error_perm,e:
        if e.args and e.args[0][:3]=='550':
	  print "Directory to upload to does not exist."
	  sys.exit(1)
	else:
	  raise
    if debug:
        print "D: Directory to upload to: %s" % incoming
    for afile in files_to_upload:
        path_to_package, package_name = os.path.split(afile)
        try:
            if debug:
                print "D: Uploading File: %s" % afile
	    if progress:
	      try:
		size = os.stat(afile).st_size
	      except:
		size = -1
		if debug:
		  print "D: Determining size of file '%s' failed"%afile
	    f = open(afile,'r')
	    if progress:
	      f = dputhelper.FileWithProgress(f, ptype=progress,
					      progressf=sys.stderr,
					      size=size)
	    # print without linefeed
	    sys.stdout.write("  %s: "% package_name)
	    sys.stdout.flush()
            ftp_connection.storbinary('STOR ' + package_name, \
				      f, 1024)
	    f.close()
            print "done."
        except ftplib.all_errors, e:
            print "\nError '%s' during ftp transfer of %s"%(str(e),package_name)
	    if isinstance(e,ftplib.Error) and e.args and e.args[0][:3]=='553':
	      print """Note: This problem might be caused by files already existent on the server.
      For the official Debian upload queues, the dcut(1) utility can be used
      to remove stale files from unsuccessful uploads."""
	    elif isinstance(e,ftplib.Error) and e.args and e.args[0][:1]=='5':
	      print """Note: This error might indicate a problem with your passive_ftp setting.
      Please consult dput.cf(5) for details on this configuration option."""
	    if debug:
		print "D: Should exit silently now, but will throw exception for debug."
		raise
            sys.exit(1)
    ftp_connection.quit()
