.\" dpkg manual page - dpkg-query(1)
.\"
.\" Copyright © 2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006-2007 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2011 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH dpkg\-query 1 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
dpkg\-query \- a tool to query the dpkg database
.
.SH SYNOPSIS
.B dpkg\-query
.RI [ option "...] " command
.
.SH DESCRIPTION
\fBdpkg\-query\fP is a tool to show information about packages listed in
the \fBdpkg\fP database.
.
.SH COMMANDS
.TP
.BR \-l ", " \-\-list " [\fIpackage-name-pattern\fP...]"
List all known packages matching one or more patterns, regardless of their
status, which includes any real or virtual package referenced in any
dependency relationship field (such as \fBBreaks\fP, \fBEnhances\fP, etc.).
If no \fIpackage-name-pattern\fP is given, list all packages in
\fI%ADMINDIR%/status\fP, excluding the ones marked as not-installed (i.e.
those which have been previously purged).
Normal shell wildcard characters are allowed in \fIpackage-name-pattern\fP.
Please note you will probably have to quote \fIpackage-name-pattern\fP to
prevent the shell from performing filename expansion.
For example this will list all package names starting with \*(lqlibc6\*(rq:

.nf
  \fBdpkg\-query \-l 'libc6*'\fP
.fi

The first three columns of the output show the desired action, the package
status, and errors, in that order.

Desired action:
.nf
  u = Unknown
  i = Install
  h = Hold
  r = Remove
  p = Purge
.fi

Package status:
.nf
  n = Not-installed
  c = Config-files
  H = Half-installed
  U = Unpacked
  F = Half-configured
  W = Triggers-awaiting
  t = Triggers-pending
  i = Installed
.fi

Error flags:
.nf
  <empty> = (none)
  R = Reinst-required
.fi

An uppercase status or error letter indicates the package is likely to
cause severe problems. Please refer to \fBdpkg\fP(1) for information
about the above states and flags.

The output format of this option is not configurable, but varies
automatically to fit the terminal width. It is intended for human
readers, and is not easily machine-readable. See \fB\-W\fP (\fB\-\-show\fP)
and \fB\-\-showformat\fP for a way to configure the output format.
.TP
.BR \-W ", " \-\-show " [\fIpackage-name-pattern\fP...]"
Just like the \fB\-\-list\fP option this will list all packages matching
the given pattern. However the output can be customized using the
\fB\-\-showformat\fP option.
The default output format gives one line per matching package, each line
having the name (extended with the architecture qualifier for
\fBMulti\-Arch\fP \fBsame\fP packages) and installed version of the package,
separated by a tab.
.TP
.BR \-s ", " \-\-status " [\fIpackage-name\fP...]"
Report status of specified package. This just displays the entry in
the installed package status database.
If no \fIpackage-name\fP is specified it will display all package entries
in the status database (since dpkg 1.19.1).
When multiple \fIpackage-name\fP entries are listed, the requested status
entries are separated by an empty line, with the same order as specified
on the argument list.
.TP
.BR \-L ", " \-\-listfiles " \fIpackage-name\fP..."
List files installed to your system from \fIpackage-name\fP. When multiple
\fIpackage-name\fP are listed, the requested lists of files are separated
by an empty line, with the same order as specified on the argument list.
However, note that files created by package-specific installation-scripts
are not listed.
.TP
.BR \-\-control\-list " \fIpackage-name\fP
List control files installed to your system from \fIpackage-name\fP
(since dpkg 1.16.5).
These can be used as input arguments to \fB\-\-control\-show\fP.
.TP
.BR \-\-control\-show " \fIpackage-name\fP \fIcontrol-file\fP"
Print the \fIcontrol-file\fP installed to your system from \fIpackage-name\fP
to the standard output (since dpkg 1.16.5).
.TP
.BR \-c ", " \-\-control\-path " \fIpackage-name\fP [\fIcontrol-file\fP]"
List paths for control files installed to your system from \fIpackage-name\fP
(since dpkg 1.15.4).
If \fIcontrol-file\fP is specified then only list the path for that control
file if it is present.

\fBWarning\fP: this command is deprecated as it gives direct access to the
internal dpkg database, please switch to use \fB\-\-control\-list\fP and
\fB\-\-control\-show\fP instead for all cases where those commands might
give the same end result. Although, as long as there is still at least
one case where this command is needed (i.e. when having to remove a
damaging postrm maintainer script), and while there is no good solution
for that, this command will not get removed.
.TP
.BR \-S ", " \-\-search " \fIfilename-search-pattern\fP..."
Search for packages that own files corresponding to the given pattern.
Standard shell wildcard characters can be used in the pattern, where
asterisk (\fB*\fP) and question mark (\fB?\fP) will match a slash,
and blackslash (\fB\\\fP) will be used as an escape character.

If the first character in the \fIfilename-search-pattern\fP is none of
‘\fB*[?/\fP’ then it will be considered a substring match and will be
implicitly surrounded by ‘\fB*\fP’ (as in
\fB*\fP\fIfilename-search-pattern\fP\fB*\fP).
If the subsequent string contains any of ‘\fB*[?\\\fP’, then it will
handled like a glob pattern, otherwise any trailing ‘\fB/\fP’ or
‘\fB/.\fP’ will be removed and a literal path lookup will be performed.

This command will not list extra files created by maintainer scripts,
nor will it list alternatives.
.TP
.BR \-p ", " \-\-print\-avail " [\fIpackage-name\fP...]"
Display details about packages, as found in \fI%ADMINDIR%/available\fP.
If no \fIpackage-name\fP is specified, it will display all package entries
in the \fIavailable\fP database (since dpkg 1.19.1).
When multiple \fIpackage-name\fP are listed, the requested \fIavailable\fP
entries are separated by an empty line, with the same order as specified
on the argument list.

Users of APT-based frontends
should use \fBapt\-cache show\fP \fIpackage-name\fP instead
as the \fIavailable\fP file is only kept up-to-date when
using \fBdselect\fP.
.TP
.BR \-? ", " \-\-help
Show the usage message and exit.
.TP
.B \-\-version
Show the version and exit.
.
.SH OPTIONS
.TP
.BI \-\-admindir= dir
Change the location of the \fBdpkg\fR database. The default location is
\fI%ADMINDIR%\fP.
.TP
.B \-\-load\-avail
Also load the available file when using the \fB\-\-show\fP and \fB\-\-list\fP
commands, which now default to only querying the status file
(since dpkg 1.16.2).
.TP
.B \-\-no\-pager
Disables the use of any pager when showing information (since dpkg 1.19.2).
.TP
.BR \-f ", " \-\-showformat=\fIformat\fR
This option is used to specify the format of the output \fB\-\-show\fP
will produce (short option since dpkg 1.13.1).
The format is a string that will be output for each package listed.

In the format string, “\fB\e\fP” introduces escapes:

.nf
    \fB\en\fP  newline
    \fB\er\fP  carriage return
    \fB\et\fP  tab
.fi

“\fB\e\fP” before any other character suppresses any special
meaning of the following character, which is useful for “\fB\e\fP”
and “\fB$\fP”.

Package information can be included by inserting
variable references to package fields using the syntax
“\fB${\fP\fIfield\fR[\fB;\fP\fIwidth\fR]\fB}\fP”. Fields are
printed right-aligned unless the width is negative in which case left
alignment will be used. The following \fIfield\fRs are recognized but
they are not necessarily available in the status file (only internal
fields or fields stored in the binary package end up in it):

.nf
    \fBArchitecture\fP
    \fBBugs\fP
    \fBConffiles\fP (internal)
    \fBConfig\-Version\fP (internal)
    \fBConflicts\fP
    \fBBreaks\fP
    \fBDepends\fP
    \fBDescription\fP
    \fBEnhances\fP
    \fBEssential\fP
    \fBFilename\fP (internal, front-end related)
    \fBHomepage\fP
    \fBInstalled\-Size\fP
    \fBMD5sum\fP (internal, front-end related)
    \fBMSDOS\-Filename\fP (internal, front-end related)
    \fBMaintainer\fP
    \fBOrigin\fP
    \fBPackage\fP
    \fBPre\-Depends\fP
    \fBPriority\fP
    \fBProvides\fP
    \fBRecommends\fP
    \fBReplaces\fP
    \fBRevision\fP (obsolete)
    \fBSection\fP
    \fBSize\fP (internal, front-end related)
    \fBSource\fP
    \fBStatus\fP (internal)
    \fBSuggests\fP
    \fBTag\fP (usually not in .deb but in repository Packages files)
    \fBTriggers\-Awaited\fP (internal)
    \fBTriggers\-Pending\fP (internal)
    \fBVersion\fP
.fi

The following are virtual fields, generated by \fBdpkg\-query\fP from
values from other fields (note that these do not use valid names for
fields in control files):
.RS
.TP
.B binary:Package
It contains the binary package name with a possible architecture qualifier
like “libc6:amd64” (since dpkg 1.16.2).
An architecture qualifier will be present to make the package name unambiguous,
for example if the package has a \fBMulti\-Arch\fP field with a value of
\fBsame\fP or the package is of a foreign architecture.
.TP
.B binary:Synopsis
It contains the package short description (since dpkg 1.19.1).
.TP
.B binary:Summary
This is an alias for \fBbinary:Synopsis\fP (since dpkg 1.16.2).
.TP
.B db:Status\-Abbrev
It contains the abbreviated package status (as three characters),
such as “ii ” or “iHR” (since dpkg 1.16.2).
See the \fB\-\-list\fP command description for more details.
.TP
.B db:Status\-Want
It contains the package wanted status, part of the Status field
(since dpkg 1.17.11).
.TP
.B db:Status\-Status
It contains the package status word, part of the Status field
(since dpkg 1.17.11).
.TP
.B db:Status\-Eflag
It contains the package status error flag, part of the Status field
(since dpkg 1.17.11).
.TP
.B db-fsys:Files
It contains the list of the package filesystem entries separated by newlines
(since dpkg 1.19.3).
.TP
.B db-fsys:Last\-Modified
It contains the timestamp in seconds of the last time the package filesystem
entries were modified (since dpkg 1.19.3).
.TP
.B source:Package
It contains the source package name for this binary package
(since dpkg 1.16.2).
.TP
.B source:Version
It contains the source package version for this binary package
(since dpkg 1.16.2)
.TP
.B source:Upstream-Version
It contains the source package upstream version for this binary package
(since dpkg 1.18.16)
.RE
.IP
The default format string is “\fB${binary:Package}\et${Version}\en\fP”.
Actually, all other fields found in the status file (i.e. user defined
fields) can be requested, too. They will be printed as-is, though, no
conversion nor error checking is done on them. To get the name of the
\fBdpkg\fP maintainer and the installed version, you could run:

.nf
  \fBdpkg\-query \-W \-f='${binary:Package} ${Version}\\t${Maintainer}\\n' dpkg\fP
.fi
.
.SH EXIT STATUS
.TP
.B 0
The requested query was successfully performed.
.TP
.B 1
The requested query failed either fully or partially, due to no file or
package being found (except for \fB\-\-control\-path\fP,
\fB\-\-control\-list\fP and \fB\-\-control\-show\fP were such errors are
fatal).
.TP
.B 2
Fatal or unrecoverable error due to invalid command-line usage, or
interactions with the system, such as accesses to the database,
memory allocations, etc.
.
.SH ENVIRONMENT
.SS External environment
.TP
.B SHELL
Sets the program to execute when spawning a command via a shell
(since dpkg 1.19.2).
.TP
.B PAGER
.TQ
.B DPKG_PAGER
Sets the pager command to use (since dpkg 1.19.1), which will be executed
with «\fB$SHELL -c\fP».
If \fBSHELL\fP is not set, «\fBsh\fP» will be used instead.
The \fBDPKG_PAGER\fP overrides the \fBPAGER\fP environment variable
(since dpkg 1.19.2).
.TP
.B DPKG_ADMINDIR
If set and the \fB\-\-admindir\fP option has not been specified, it will
be used as the \fBdpkg\fP data directory.
.TP
.B DPKG_COLORS
Sets the color mode (since dpkg 1.18.5).
The currently accepted values are: \fBauto\fP (default), \fBalways\fP and
\fBnever\fP.
.SS Internal environment
.TP
.B LESS
Defined by \fBdpkg\-query\fP to “\fB-FRSXMQ\fP”, if not already set, when
spawning a pager (since dpkg 1.19.2).
To change the default behavior, this variable can be preset to some other
value including an empty string, or the \fBPAGER\fP or \fBDPKG_PAGER\fP
variables can be set to disable specific options with «\fB\-+\fP», for
example \fBDPKG_PAGER="less \-+F"\fP.
.
.SH SEE ALSO
.BR dpkg (1).

