;;File: debian-ispell.el
;;; -----------------------------------------------------------------------
;;;	$Id: debian-ispell.el,v 1.14 2005/03/04 12:24:31 agmartin Exp $	
;;; -----------------------------------------------------------------------
;;Description: Emacsen support for Debian package dictionaries-common
;;Authors: Rafael Laboissire <rafael@debian.org>
;;         Agustin Martin     <agmartin@debian.org>
;;Created on: Tue Oct 26 10:16:12 CEST 1999
;;; -----------------------------------------------------------------------

(defvar debian-dict-common-debug 
  nil
  "Some debugging info will be shown if non nil")

;;; -----------------------------------------------------------------------
;;;  Initialize the alist containing all info for the different spell
;;;  emacsen entries and provide the function to populate it
;;; -----------------------------------------------------------------------

(defvar debian-ispell-dictionary-alist 
  '((nil "[A-Za-z]" "[^A-Za-z]" "[']" nil ("-B") nil iso-8859-1))
  "Alist of dictionaries used internally by the Debian ispell
initialization scheme.  Its value will be used to set
`ispell-dictionary-alist' after ispell.el is loaded.

Do not change this variable directly.  Use the
`debian-ispell-add-dictionary-entry' function instead.")

(defvar debian-valid-dictionary-list nil
  "A list that will contain the list of emacsen names provided by
registered ispell or aspell dicts"
  )

(defun debian-ispell-add-dictionary-entry (entry &optional name)
  "Adds an ENTRY to the ispell-dictionary-alist variable. See the 
documentation of the variable ispell-dictionary-alist for the format 
of ENTRY."
  (set-variable 'debian-ispell-dictionary-alist
		(append (list entry) debian-ispell-dictionary-alist))
  (set-variable 'debian-valid-dictionary-list
		(add-to-list 'debian-valid-dictionary-list (car entry)))
  )

;;; -----------------------------------------------------------------------
;;;  Guess default ispell dictionary under emacs and make ispell.el use it
;;; -----------------------------------------------------------------------

(defvar debian-ispell-dictionary 
  nil
  "The name of the ispell dictionary that will become the default after
loading of ispell.el.")

;; Load the file containing the default value for debian-ispell-dictionary

(if (file-exists-p "/var/cache/dictionaries-common/emacsen-ispell-default.el")
    (load "/var/cache/dictionaries-common/emacsen-ispell-default.el"))

;;; ----------------

(defvar debian-aspell-dictionary 
  nil
  "The name of the aspell dictionary that will become the default after
loading of ispell.el.")

(defvar debian-aspell-equivs-alist 
  '((nil nil))
  "Alist of equivalences between locales and aspell dictionaries,
used internally by the debian ispell.el initialization scheme.
Do not change this variable directly. It is autogenerated 
from data supplied by aspell dictionaries maintainers")

;;; ---------------

(defun get-debian-aspell-default ()
  "Guess emacsen entry associated to the current LANG locale"
  (let (prefixes
	suffixes
	debian-aspell-default)
    (setq suffixes '("^" "@" "_"))
    (catch 'tag
      (while suffixes
	(setq prefixes '("" "1:"))
	(while prefixes
	  (if (setq debian-aspell-default
		    (cdr (assoc (concat (car prefixes) 
					(car (split-string debian-lang (car suffixes))))
				debian-aspell-equivs-alist)))
	      (throw 'tag (car debian-aspell-default)))
	  ;;
	  (setq prefixes (cdr prefixes))
	  )
	(setq suffixes (cdr suffixes))
	)
      )
    )
  )

;;; ------------- Guess emacsen entry for aspell after LANG

(setq debian-lang (getenv "LANG"))
(condition-case ()
    (setq debian-aspell-dictionary (get-debian-aspell-default))
  (error
   (setq debian-aspell-dictionary nil)))

(fmakunbound 'get-debian-aspell-default)

;;; --------------

(defun debian-set-ispell-dictionary ()
  "Set ispell default to the debconf selected one if ispell-program-name is
ispell or, when ispell-program-name is aspell, to the value guessed after
LANG if any."
  (if (not ispell-local-dictionary)
      (progn
	(if (and (equal ispell-program-name "ispell") debian-ispell-dictionary)
	    (setq ispell-local-dictionary debian-ispell-dictionary))
	(if (and (equal ispell-program-name "aspell") debian-aspell-dictionary)
	    (setq ispell-local-dictionary debian-aspell-dictionary))
	)
    )
  (if debian-dict-common-debug
      (message "- dictionaries d-i-d:%s d-a-d:%s i-l-d:%s" 
	       debian-ispell-dictionary 
	       debian-aspell-dictionary
	       ispell-local-dictionary))
  )

;;; ---------------------------------------------------------------------------
;;;   Make sure the patched ispell.el is first in the loadpath
;;; ---------------------------------------------------------------------------

(setq load-path
      (append (list (concat "/usr/share/" 
			    (symbol-name debian-emacs-flavor) 
			    "/site-lisp/dictionaries-common"))
	       load-path))

;;; --------------------------------------------------------------------------
;;; A home made exec-installed-p to test for {i,a}spell executable existence
;;; Implemented here to avoid apel dependency. Will be nulled at the end
;;; --------------------------------------------------------------------------

(defun debiandc-exec-installed-p (infile)
  "Checking for an executable file in the exec-path. 
Implemented here to avoid apel dependency. This is much much simpler,
we do not need all that apel's portability. Internal use funcion."
  (let (file paths)
    (setq paths exec-path)
    (catch 'tag
      (while paths
	(setq file (expand-file-name infile (car paths)))
	(if (file-executable-p file)
	    (throw 'tag t)
	  )
	(setq paths (cdr paths))
	)
      )
    )
  )

;; Fallback to aspell if ispell is not present.
;; Will be overriden by ~/.emacs selection if present

(if (not (debiandc-exec-installed-p "ispell"))
    (setq ispell-program-name "aspell"))

(fmakunbound 'debiandc-exec-installed-p)

;;; -----------------------------------------------------------------------

;; Local Variables:
;; mode: lisp
;; End:
