"""testing desktopcouch/start_local_couchdb.py module"""

import os
import shutil

from mocker import MockerTestCase as TestCase

import desktopcouch.application.tests as test_environment

DIRS = [
"databases",
  "databases/nocfg",
  "databases/cfg",
  "databases/cfg_and_empty_design",
    "databases/cfg_and_empty_design/_design",
  "databases/cfg_and_design_no_views",
    "databases/cfg_and_design_no_views/_design",
    "databases/cfg_and_design_no_views/_design/doc1",
    "databases/cfg_and_design_no_views/_design/doc1/views",
  "databases/cfg_and_design_one_view_no_map",
    "databases/cfg_and_design_one_view_no_map/_design",
    "databases/cfg_and_design_one_view_no_map/_design/doc1",
    "databases/cfg_and_design_one_view_no_map/_design/doc1/views",
    "databases/cfg_and_design_one_view_no_map/_design/doc1/views/view1",
  "databases/cfg_and_design_one_view_map_no_reduce",
    "databases/cfg_and_design_one_view_map_no_reduce/_design",
    "databases/cfg_and_design_one_view_map_no_reduce/_design/doc1",
    "databases/cfg_and_design_one_view_map_no_reduce/_design/doc1/views",
    "databases/cfg_and_design_one_view_map_no_reduce/_design/doc1/views/view1",
  "databases/cfg_and_design_one_view_map_reduce",
    "databases/cfg_and_design_one_view_map_reduce/_design",
    "databases/cfg_and_design_one_view_map_reduce/_design/doc1",
    "databases/cfg_and_design_one_view_map_reduce/_design/doc1/views",
    "databases/cfg_and_design_one_view_map_reduce/_design/doc1/views/view1",
  "databases/cfg_and_design_two_views_map_reduce",
    "databases/cfg_and_design_two_views_map_reduce/_design",
    "databases/cfg_and_design_two_views_map_reduce/_design/doc1",
    "databases/cfg_and_design_two_views_map_reduce/_design/doc1/views",
    "databases/cfg_and_design_two_views_map_reduce/_design/doc1/views/view1",
    "databases/cfg_and_design_two_views_map_reduce/_design/doc1/views/view2",
  ]

FILES = {
    "databases/cfg/database.cfg": "",
    "databases/cfg_and_empty_design/database.cfg": "",
    "databases/cfg_and_design_no_views/database.cfg": "",
    "databases/cfg_and_design_one_view_no_map/database.cfg": "",
    "databases/cfg_and_design_one_view_map_no_reduce/database.cfg": "",
    "databases/cfg_and_design_one_view_map_no_reduce/_design/doc1/views/view1/"
    "map.js": "cfg_and_design_one_view_map_no_reduce:map",
    "databases/cfg_and_design_one_view_map_reduce/database.cfg": "",
    "databases/cfg_and_design_one_view_map_reduce/_design/doc1/views/view1/"
    "map.js": "cfg_and_design_one_view_map_reduce:map",
    "databases/cfg_and_design_one_view_map_reduce/_design/doc1/views/view1/"
    "reduce.js": "cfg_and_design_one_view_map_reduce:reduce",
    "databases/cfg_and_design_two_views_map_reduce/database.cfg": "",
    "databases/cfg_and_design_two_views_map_reduce/_design/doc1/views/view1/"
    "map.js": "cfg_and_design_two_views_map_reduce:map1",
    "databases/cfg_and_design_two_views_map_reduce/_design/doc1/views/view1/"
    "reduce.js": "cfg_and_design_two_views_map_reduce:reduce1",
    "databases/cfg_and_design_two_views_map_reduce/_design/doc1/views/view2/"
    "map.js": "cfg_and_design_two_views_map_reduce:map2",
    "databases/cfg_and_design_two_views_map_reduce/_design/doc1/views/view2/"
    "reduce.js": "cfg_and_design_two_views_map_reduce:reduce2",
}


class TestUpdateDesignDocuments(TestCase):
    """Testing that the database/designdoc filesystem loader works"""

    def setUp(self):
        # create temp folder with databases and design documents in
        super(TestUpdateDesignDocuments, self).setUp()
        xdg_data = os.path.split(test_environment.test_context.db_dir)[0]
        try:
            shutil.rmtree(os.path.join(xdg_data, "desktop-couch"))
        except OSError:
            # don't worry if folder does not exist
            pass
        os.mkdir(os.path.join(xdg_data, "desktop-couch"))
        for d in DIRS:
            os.mkdir(os.path.join(xdg_data, "desktop-couch", d))
        for f, data in FILES.items():
            fp = open(os.path.join(xdg_data, "desktop-couch", f), "w")
            fp.write(data)
            fp.close()

    def test_create_databases_and_design_docs(self):  # pylint: disable=R0201
        """Are databases and design documents correctly
           created from the filesystem?"""
        # Mock DesktopDatabase
        couchdb = self.mocker.replace(
            "desktopcouch.application.server.DesktopDatabase")

        # databases that should be created
        couchdb("cfg", create=True, ctx=test_environment.test_context)
        couchdb(
            "cfg_and_empty_design", create=True,
            ctx=test_environment.test_context)
        couchdb(
            "cfg_and_design_no_views", create=True,
            ctx=test_environment.test_context)
        couchdb(
            "cfg_and_design_one_view_no_map", create=True,
            ctx=test_environment.test_context)
        couchdb(
            "cfg_and_design_one_view_map_no_reduce", create=True,
            ctx=test_environment.test_context)

        dbmock1 = self.mocker.mock()
        self.mocker.result(dbmock1)
        dbmock1.add_view(
            "view1", "cfg_and_design_one_view_map_no_reduce:map",
            design_doc="doc1")
        couchdb(
            "cfg_and_design_one_view_map_reduce", create=True,
            ctx=test_environment.test_context)
        dbmock2 = self.mocker.mock()
        self.mocker.result(dbmock2)
        dbmock2.add_view(
            "view1", "cfg_and_design_one_view_map_reduce:map",
            reduce_js="cfg_and_design_one_view_map_reduce:reduce",
            design_doc="doc1")
        couchdb(
            "cfg_and_design_two_views_map_reduce", create=True,
            ctx=test_environment.test_context)
        dbmock3 = self.mocker.mock()
        self.mocker.result(dbmock3)
        dbmock3.add_view(
            "view1", "cfg_and_design_two_views_map_reduce:map1",
            reduce_js="cfg_and_design_two_views_map_reduce:reduce1",
            design_doc="doc1")
        dbmock3.add_view(
            "view2", "cfg_and_design_two_views_map_reduce:map2",
            reduce_js="cfg_and_design_two_views_map_reduce:reduce2",
            design_doc="doc1")

        # actually call update_design_documents to confirm that it creates
        # all the right things
        self.mocker.replay()

        from desktopcouch.application.migration import (
            update_design_documents)
        update_design_documents(ctx=test_environment.test_context)
