#!/usr/bin/python
# Copyright 2009 Canonical Ltd.
#
# This file is part of desktopcouch.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
#
# Author: Chad Miller <chad.miller@canonical.com>
"""
Stop local CouchDB server.
"""

import os
import desktopcouch
import time
import signal
import errno

def stop_couchdb(pid=None):
    by_pid = pid
    if pid is None:
        pid = desktopcouch.find_pid(start_if_not_running=False)
    while pid is not None:
        try:
            os.kill(pid, signal.SIGTERM)
        except OSError, e:
            if e.errno == errno.ESRCH:
                break
            raise

        for retry in xrange(300):
            try:
                os.kill(pid, 0)  # test existence. sig-zero is special.
            except OSError:
                break
            time.sleep(0.01)
        if by_pid:
            pid = None
        else:
            pid = desktopcouch.find_pid(start_if_not_running=False)

if __name__ == "__main__":
    stop_couchdb()
