from oauth import oauth
import logging
import httplib2
import simplejson
import gnomekeyring

name = "Ubuntu One"
description = "The Ubuntu One cloud service"

oauth_consumer_key = "ubuntuone"
oauth_consumer_secret = "hammertime"

def is_active():
    """Can we deliver information?"""
    return get_oauth_data() is not None

oauth_data = None
def get_oauth_data():
    """Information needed to replicate to a server."""
    global oauth_data
    if oauth_data is not None:
        return oauth_data

    try:
        matches = gnomekeyring.find_items_sync(
            gnomekeyring.ITEM_GENERIC_SECRET,
            {'ubuntuone-realm': "https://ubuntuone.com",
             'oauth-consumer-key': oauth_consumer_key})
        if matches:
            # parse "a=b&c=d" to {"a":"b","c":"d"}
            kv_list = [x.split("=", 1) for x in matches[0].secret.split("&")]
            keys, values = zip(*kv_list)
            keys = [k.replace("oauth_", "") for k in keys]
            oauth_data = dict(zip(keys, values))
            oauth_data.update({
                "consumer_key": oauth_consumer_key,
                "consumer_secret": oauth_consumer_secret,
            })
            return oauth_data
    except ImportError, e:
        logging.info("Can't replicate to Ubuntu One cloud without credentials."
                " %s", e)
    except gnomekeyring.NoMatchError:
        logging.info("This machine hasn't authorized itself to Ubuntu One; "
                "replication to the cloud isn't possible until it has.  See "
                "'ubuntuone-client-applet'.")
    except gnomekeyring.NoKeyringDaemonError:
        logging.error("No keyring daemon found in this session, so we have "
                "no access to Ubuntu One data.")

def get_oauth_token(consumer):
    """Get the token from the keyring"""
    try:
        items = gnomekeyring.find_items_sync(
            gnomekeyring.ITEM_GENERIC_SECRET,
            {'ubuntuone-realm': "https://one.ubuntu.com",
             'oauth-consumer-key': consumer.key})
    except gnomekeyring.NoMatchError:
        logging.info("No o.u.c key.  Maybe there's uo.c key?")
        items = gnomekeyring.find_items_sync(
            gnomekeyring.ITEM_GENERIC_SECRET,
            {'ubuntuone-realm': "https://ubuntuone.com",
             'oauth-consumer-key': consumer.key})
    if len(items):
        return oauth.OAuthToken.from_string(items[0].secret)

def get_oauth_request_header(consumer, access_token, http_url):
    """Get an oauth request header given the token and the url"""
    signature_method = oauth.OAuthSignatureMethod_PLAINTEXT()
    assert http_url.startswith("https")
    oauth_request = oauth.OAuthRequest.from_consumer_and_token(
        http_url=http_url,
        http_method="GET",
        oauth_consumer=consumer,
        token=access_token)
    oauth_request.sign_request(signature_method, consumer, access_token)
    return oauth_request.to_header()


class PrefixGetter():
    def __init__(self):
        self.str = None
        self.oauth_header = None

    def __str__(self):
        if self.str is not None:
            return self.str

        url = "https://one.ubuntu.com/api/account/"
        if self.oauth_header is None:
            consumer = oauth.OAuthConsumer(oauth_consumer_key,
                    oauth_consumer_secret)
            try:
                access_token = get_oauth_token(consumer)
            except gnomekeyring.NoKeyringDaemonError:
                logging.info("No keyring daemon is running for this session.")
                raise ValueError("No keyring access")
            if not access_token:
                logging.info("Could not get access token from keyring")
                raise ValueError("No keyring access")
            self.oauth_header = get_oauth_request_header(
                consumer, access_token, url)

        client = httplib2.Http()
        resp, content = client.request(url, "GET", headers=self.oauth_header)
        if resp['status'] == "200":
            document = simplejson.loads(content)
            if "couchdb_root" not in document:
                raise ValueError("couchdb_root not found in %s" % (document,))
            self.str = document["couchdb_root"]
        else:
            logging.error(
                "Couldn't talk to %r.  Got HTTP %s", url, resp['status'])
            raise ValueError("HTTP %s for %r" % (resp['status'], url))

        return self.str

# Access to this as a string fires off functions.
db_name_prefix = PrefixGetter()

if __name__ == "__main__":
    logging.basicConfig(level=logging.DEBUG, format="%(message)s")
    print str(db_name_prefix)
