# Copyright 2009 Canonical Ltd.
#
# This file is part of desktopcouch-contacts.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
#
# Authors: Nicola Larosa <nicola.larosa@canonical.com>

"""
Tests for the random contacts creation testing support code.

These tests depend on the specific random generation algorithm used in the
"random" stdlib module.
"""

import random

import testtools

from desktopcouch.contacts.testing import create as create

class TestCreate(testtools.TestCase):
    """Test the random creation testing support code."""

    def test_head_or_tails(self):
        """
        Test the head_or_tails function.
        Once the rndgen algo is seeded, the first four calls to
        create.head_or_tails will yield True, True, False, False.
        """
        random.seed(0)
        self.assert_(create.head_or_tails())
        self.assert_(create.head_or_tails())
        self.assertFalse(create.head_or_tails())
        self.assertFalse(create.head_or_tails())

    def test_random_bools(self):
        """
        Test the random_bools function. See the doc for the head_or_tails test.
        """
        self.assertRaises(RuntimeError, create.random_bools, 1)
        random.seed(0)
        self.assertEqual(len(create.random_bools(2)), 2) # [True, True]
        self.assert_(any(create.random_bools(2))) # orig.: [False, False]
        random.seed(0)
        create.random_bools(2) # [True, True]
        self.assertFalse(any(
            create.random_bools(2, at_least_one_true=False))) # [False, False]

    def test_create_many_contacts(self):
        """Run the create_many_contacts function."""
        create.create_many_contacts()
