/* scoreprops.c
 * Callback that creates a "Score Properties" dialog box.
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999-2005 Adam Tee, Matthew Hiller */

#include <stdlib.h>
#include <string.h>
#include <denemo/denemo.h>
#include "utils.h"
#include "commandfuncs.h"
#include "dialogs.h"

#define COL_NAME 0
#define COL_VALUE 1
#define COL_PTR 2

static void
cell_edited (GtkCellRendererText * cellrenderertext,
	     gchar * path_string, gchar * new_text, GtkTreeModel * model)
{
  GtkTreePath *path = gtk_tree_path_new_from_string (path_string);
  GtkTreeIter iter;

  gtk_tree_model_get_iter (model, &iter, path);
  gtk_list_store_set (GTK_LIST_STORE (model), &iter, COL_VALUE, new_text, -1);
  gtk_tree_path_free (path);
}


/**
 * Create and run a modal score properties dialog.
 */
void
score_properties_dialog (GtkAction * action, struct scoreinfo *si)
{
  GtkWidget *dialog;
  GtkWidget *notebook;
  GtkWidget *scrolled_window;
  GtkWidget *label;
  GtkWidget *table;
  GtkWidget *list;
  GtkListStore *list_store = NULL;
  GtkTreeIter iter;
  GtkCellRenderer *renderer;
  GtkWidget *measure_width;
  GtkWidget *staff_spacing;

  g_assert (si != NULL);

  dialog = gtk_dialog_new_with_buttons (_("Score properties"),
					GTK_WINDOW (si->window),
					(GtkDialogFlags) (GTK_DIALOG_MODAL |
							  GTK_DIALOG_DESTROY_WITH_PARENT),
					GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
					GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT,
					NULL);

  gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_ACCEPT);
  gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);

  notebook = gtk_notebook_new ();
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), notebook, TRUE,
		      TRUE, 0);

  // Headers
  /* no code for this yet - just edit textually */
  if (!si->lily_file)
    {
      scrolled_window = gtk_scrolled_window_new (NULL, NULL);
      gtk_container_set_border_width (GTK_CONTAINER (scrolled_window), 12);
      gtk_widget_set_size_request (scrolled_window, 350, 300);
      gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				      GTK_POLICY_AUTOMATIC,
				      GTK_POLICY_AUTOMATIC);
      gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW
					   (scrolled_window), GTK_SHADOW_IN);

      label = gtk_label_new_with_mnemonic (_("_Headers"));
      gtk_notebook_append_page (GTK_NOTEBOOK (notebook), scrolled_window,
				label);

      list_store = gtk_list_store_new (3, G_TYPE_STRING,	/* label */
				       G_TYPE_STRING,	/* value */
				       G_TYPE_POINTER);	/* pointer to the corresponding header field */

      list = gtk_tree_view_new_with_model (GTK_TREE_MODEL (list_store));
      gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (list),
						   0, "Name",
						   gtk_cell_renderer_text_new
						   (), "text", 0, NULL);
      gtk_container_add (GTK_CONTAINER (scrolled_window), list);
      renderer = gtk_cell_renderer_text_new ();
      g_object_set (renderer, "editable", TRUE, NULL);
      g_object_set (renderer, "width", 200, NULL);
      g_signal_connect (renderer, "edited", (GCallback) cell_edited,
			list_store);
      gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (list), 1,
						   "Value", renderer, "text",
						   1, NULL);

      gtk_list_store_append (list_store, &iter);
      gtk_list_store_set (list_store, &iter,
			  COL_NAME, _("Title"),
			  COL_VALUE, si->headerinfo->title->str,
			  COL_PTR, &(si->headerinfo->title->str), -1);

      gtk_list_store_append (list_store, &iter);
      gtk_list_store_set (list_store, &iter,
			  COL_NAME, _("Subtitle"),
			  COL_VALUE, si->headerinfo->subtitle->str,
			  COL_PTR, &(si->headerinfo->subtitle->str), -1);

      gtk_list_store_append (list_store, &iter);
      gtk_list_store_set (list_store, &iter,
			  COL_NAME, _("Poet"),
			  COL_VALUE, si->headerinfo->poet->str,
			  COL_PTR, &(si->headerinfo->poet->str), -1);

      gtk_list_store_append (list_store, &iter);
      gtk_list_store_set (list_store, &iter,
			  COL_NAME, _("Composer"),
			  COL_VALUE, si->headerinfo->composer->str,
			  COL_PTR, &(si->headerinfo->composer->str), -1);

      gtk_list_store_append (list_store, &iter);
      gtk_list_store_set (list_store, &iter,
			  COL_NAME, _("Meter"),
			  COL_VALUE, si->headerinfo->meter->str,
			  COL_PTR, &(si->headerinfo->meter->str), -1);

      gtk_list_store_append (list_store, &iter);
      gtk_list_store_set (list_store, &iter,
			  COL_NAME, _("Opus"),
			  COL_VALUE, si->headerinfo->opus->str,
			  COL_PTR, &(si->headerinfo->opus->str), -1);

      gtk_list_store_append (list_store, &iter);
      gtk_list_store_set (list_store, &iter,
			  COL_NAME, _("Arranger"),
			  COL_VALUE, si->headerinfo->arranger->str,
			  COL_PTR, &(si->headerinfo->arranger->str), -1);

      gtk_list_store_append (list_store, &iter);
      gtk_list_store_set (list_store, &iter,
			  COL_NAME, _("Instrument"),
			  COL_VALUE, si->headerinfo->instrument->str,
			  COL_PTR, &(si->headerinfo->instrument->str), -1);

      gtk_list_store_append (list_store, &iter);
      gtk_list_store_set (list_store, &iter,
			  COL_NAME, _("Dedication"),
			  COL_VALUE, si->headerinfo->dedication->str,
			  COL_PTR, &(si->headerinfo->dedication->str), -1);

      gtk_list_store_append (list_store, &iter);
      gtk_list_store_set (list_store, &iter,
			  COL_NAME, _("Pice"),
			  COL_VALUE, si->headerinfo->piece->str,
			  COL_PTR, &(si->headerinfo->piece->str), -1);

      gtk_list_store_append (list_store, &iter);
      gtk_list_store_set (list_store, &iter,
			  COL_NAME, _("Head"),
			  COL_VALUE, si->headerinfo->head->str,
			  COL_PTR, &(si->headerinfo->head->str), -1);

      gtk_list_store_append (list_store, &iter);
      gtk_list_store_set (list_store, &iter,
			  COL_NAME, _("Copyright"),
			  COL_VALUE, si->headerinfo->copyright->str,
			  COL_PTR, &(si->headerinfo->copyright->str), -1);

      gtk_list_store_append (list_store, &iter);
      gtk_list_store_set (list_store, &iter,
			  COL_NAME, _("Footer"),
			  COL_VALUE, si->headerinfo->footer->str,
			  COL_PTR, &(si->headerinfo->footer->str), -1);

      gtk_list_store_append (list_store, &iter);
      gtk_list_store_set (list_store, &iter,
			  COL_NAME, _("Tagline"),
			  COL_VALUE, si->headerinfo->tagline->str,
			  COL_PTR, &(si->headerinfo->tagline->str), -1);

    }

  // Layout
  label = gtk_label_new_with_mnemonic (_("La_yout"));

  table = gtk_table_new (2, 2, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (table), 12);
  gtk_table_set_row_spacings (GTK_TABLE (table), 8);
  gtk_table_set_col_spacings (GTK_TABLE (table), 8);

  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), table, label);

  label = gtk_label_new (_("Measure width (pixels):"));
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  measure_width = gtk_spin_button_new_with_range (10.0, 1000, 1.0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (measure_width),
			     (gdouble) si->measurewidth);
  gtk_table_attach (GTK_TABLE (table), measure_width, 1, 2, 0, 1,
		    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0,
		    0);


  label = gtk_label_new (_("Staff spacing (pixels):"));
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  staff_spacing =
    gtk_spin_button_new_with_range (2 * STAFF_HEIGHT, 1000, 1.0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (staff_spacing),
			     (gdouble) si->staffspace);
  gtk_table_attach (GTK_TABLE (table), staff_spacing, 1, 2, 1, 2,
		    (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0,
		    0);



  gtk_widget_show_all (dialog);

  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
    {
      // Set headers
      if (!si->lily_file)
	{
	  gchar *value;
	  GString *dest;
	  gtk_tree_model_get_iter_first (GTK_TREE_MODEL (list_store), &iter);
	  do
	    {
	      gtk_tree_model_get (GTK_TREE_MODEL (list_store), &iter,
				  COL_VALUE, &value, COL_PTR, &dest, -1);
	      g_string_assign (dest, value);
	    }
	  while (gtk_tree_model_iter_next
		 (GTK_TREE_MODEL (list_store), &iter));
	}

      // Set layout options
      gint width =
	gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (measure_width));
      if (width != si->measurewidth)
	{
	  si->measurewidth = width;
	  adjustmeasurewidth (si, 0);
	  gtk_widget_draw (si->scorearea, NULL);
	}

      gint spacing =
	gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (staff_spacing));
      if (spacing != si->staffspace)
	{
	  si->staffspace = spacing;
	  gtk_widget_draw (si->scorearea, NULL);
	}

    }
  gtk_widget_destroy (dialog);
}
