#!/bin/sh

dbc_dbname="testdbname"
dbc_dbuser="testdbuser"
dbc_dbadmin="testadmin"
dbc_dbpass="testdbpass"
dbc_dbadmpass="testadmpass"
dbc_dbserver="testserver"
dbc_dbport="testport"
test_dbtype="mysql"

# get some common functions
. `dirname "$0"`/functions
. `dirname "$0"`/common
. ${_dbc_root}/internal/mysql

test_generate_mycnf(){
  local cnf DIFF

  DIFF='diff -b -u -I "^# generated on"'

  cnf=`_dbc_generate_mycnf`
  assertTrue "_dbc_generate_mycnf returned error" $?
  assertFilesEqual ./data/generate_mycnf.txt "$cnf"
  rm -f "$cnf"
}

test_mysql_check_connect(){
    common_check_connect
}

test_dbc_mysql_exec_file(){
    dbc_common_exec_file
}

test_mysql_exec_command(){
    common_exec_command
}

test_dbc_mysql_check_database(){
    dbc_common_check_database
}

test_dbc_mysql_check_user(){
    dbc_common_check_user
}

test_dbc_mysql_createdb(){
    dbc_common_createdb
}

test_dbc_mysql_dropdb(){
    dbc_common_dropdb
}

test_dbc_mysql_createuser(){
    dbc_common_createuser
}

test_dbc_mysql_dropuser(){
    dbc_common_dropuser
}

test_dbc_mysql_dump(){
    dbc_common_dump
}

test_dbc_mysql_db_installed(){
    dbc_common_db_installed
}

test_dbc_mysql_escape_str(){
    dbc_common_escape_str
}

. /usr/share/shunit2/shunit2
