/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz.h>

#define _COLORFILTER_OPTIONS_INTERNAL
#include "colorfilter_options.h"

static int displayPrivateIndex;

static CompMetadata colorfilterOptionsMetadata;

static CompPluginVTable *colorfilterPluginVTable = NULL;
CompPluginVTable colorfilterOptionsVTable;

#define GET_COLORFILTER_OPTIONS_DISPLAY(d) \
        ((ColorfilterOptionsDisplay *) (d)->privates[displayPrivateIndex].ptr)

#define COLORFILTER_OPTIONS_DISPLAY(d) \
        ColorfilterOptionsDisplay *od = GET_COLORFILTER_OPTIONS_DISPLAY (d)

#define GET_COLORFILTER_OPTIONS_SCREEN(s, od) \
        ((ColorfilterOptionsScreen *) (s)->privates[(od)->screenPrivateIndex].ptr)

#define COLORFILTER_OPTIONS_SCREEN(s) \
        ColorfilterOptionsScreen *os = GET_COLORFILTER_OPTIONS_SCREEN (s, GET_COLORFILTER_OPTIONS_DISPLAY (s->display))

typedef struct _ColorfilterOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[ColorfilterDisplayOptionNum];
    colorfilterDisplayOptionChangeNotifyProc notify[ColorfilterDisplayOptionNum];
} ColorfilterOptionsDisplay;

typedef struct _ColorfilterOptionsScreen
{
    CompOption opt[ColorfilterScreenOptionNum];
    colorfilterScreenOptionChangeNotifyProc notify[ColorfilterScreenOptionNum];
} ColorfilterOptionsScreen;

CompAction * colorfilterGetToggleWindow (CompDisplay *d)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    return &od->opt[ColorfilterDisplayOptionToggleWindow].value.action;
}

void colorfilterSetToggleWindowInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->opt[ColorfilterDisplayOptionToggleWindow].value.action.initiate = init;
}

void colorfilterSetToggleWindowTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->opt[ColorfilterDisplayOptionToggleWindow].value.action.terminate = term;
}

CompOption * colorfilterGetToggleWindowOption (CompDisplay *d)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    return &od->opt[ColorfilterDisplayOptionToggleWindow];
}

void colorfilterSetToggleWindowNotify (CompDisplay *d, colorfilterDisplayOptionChangeNotifyProc notify)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->notify[ColorfilterDisplayOptionToggleWindow] = notify;
}

CompAction * colorfilterGetToggleScreen (CompDisplay *d)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    return &od->opt[ColorfilterDisplayOptionToggleScreen].value.action;
}

void colorfilterSetToggleScreenInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->opt[ColorfilterDisplayOptionToggleScreen].value.action.initiate = init;
}

void colorfilterSetToggleScreenTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->opt[ColorfilterDisplayOptionToggleScreen].value.action.terminate = term;
}

CompOption * colorfilterGetToggleScreenOption (CompDisplay *d)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    return &od->opt[ColorfilterDisplayOptionToggleScreen];
}

void colorfilterSetToggleScreenNotify (CompDisplay *d, colorfilterDisplayOptionChangeNotifyProc notify)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->notify[ColorfilterDisplayOptionToggleScreen] = notify;
}

CompAction * colorfilterGetSwitchFilter (CompDisplay *d)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    return &od->opt[ColorfilterDisplayOptionSwitchFilter].value.action;
}

void colorfilterSetSwitchFilterInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->opt[ColorfilterDisplayOptionSwitchFilter].value.action.initiate = init;
}

void colorfilterSetSwitchFilterTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->opt[ColorfilterDisplayOptionSwitchFilter].value.action.terminate = term;
}

CompOption * colorfilterGetSwitchFilterOption (CompDisplay *d)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    return &od->opt[ColorfilterDisplayOptionSwitchFilter];
}

void colorfilterSetSwitchFilterNotify (CompDisplay *d, colorfilterDisplayOptionChangeNotifyProc notify)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    od->notify[ColorfilterDisplayOptionSwitchFilter] = notify;
}

CompListValue * colorfilterGetFilters (CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ColorfilterScreenOptionFilters].value.list;
}

CompOption * colorfilterGetFiltersOption (CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ColorfilterScreenOptionFilters];
}

void colorfilterSetFiltersNotify (CompScreen *s, colorfilterScreenOptionChangeNotifyProc notify)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    os->notify[ColorfilterScreenOptionFilters] = notify;
}

Bool colorfilterGetFilterDecorations (CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return os->opt[ColorfilterScreenOptionFilterDecorations].value.b;
}

CompOption * colorfilterGetFilterDecorationsOption (CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ColorfilterScreenOptionFilterDecorations];
}

void colorfilterSetFilterDecorationsNotify (CompScreen *s, colorfilterScreenOptionChangeNotifyProc notify)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    os->notify[ColorfilterScreenOptionFilterDecorations] = notify;
}

CompMatch * colorfilterGetFilterMatch (CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ColorfilterScreenOptionFilterMatch].value.match;
}

CompOption * colorfilterGetFilterMatchOption (CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ColorfilterScreenOptionFilterMatch];
}

void colorfilterSetFilterMatchNotify (CompScreen *s, colorfilterScreenOptionChangeNotifyProc notify)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    os->notify[ColorfilterScreenOptionFilterMatch] = notify;
}

CompMatch * colorfilterGetExcludeMatch (CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ColorfilterScreenOptionExcludeMatch].value.match;
}

CompOption * colorfilterGetExcludeMatchOption (CompScreen *s)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ColorfilterScreenOptionExcludeMatch];
}

void colorfilterSetExcludeMatchNotify (CompScreen *s, colorfilterScreenOptionChangeNotifyProc notify)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    os->notify[ColorfilterScreenOptionExcludeMatch] = notify;
}

CompOption * colorfilterGetDisplayOption (CompDisplay *d, ColorfilterDisplayOptions num)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * colorfilterGetScreenOption (CompScreen *s, ColorfilterScreenOptions num)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo colorfilterOptionsDisplayOptionInfo[] = {
    { "toggle_window", "action", 0, 0, 0 },
    { "toggle_screen", "action", 0, 0, 0 },
    { "switch_filter", "action", 0, 0, 0 },
};

static Bool colorfilterOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, char *name, CompOptionValue *value)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, ColorfilterDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ColorfilterDisplayOptionToggleWindow:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ColorfilterDisplayOptionToggleWindow])
                (*od->notify[ColorfilterDisplayOptionToggleWindow]) (d, o, ColorfilterDisplayOptionToggleWindow);
            return TRUE;
        }
        break;
     case ColorfilterDisplayOptionToggleScreen:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ColorfilterDisplayOptionToggleScreen])
                (*od->notify[ColorfilterDisplayOptionToggleScreen]) (d, o, ColorfilterDisplayOptionToggleScreen);
            return TRUE;
        }
        break;
     case ColorfilterDisplayOptionSwitchFilter:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ColorfilterDisplayOptionSwitchFilter])
                (*od->notify[ColorfilterDisplayOptionSwitchFilter]) (d, o, ColorfilterDisplayOptionSwitchFilter);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * colorfilterOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    COLORFILTER_OPTIONS_DISPLAY(d);
    *count = ColorfilterDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo colorfilterOptionsScreenOptionInfo[] = {
    { "filters", "list", "<type>string</type>", 0, 0 },
    { "filter_decorations", "bool", 0, 0, 0 },
    { "filter_match", "match", 0, 0, 0 },
    { "exclude_match", "match", 0, 0, 0 },
};

static Bool colorfilterOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, char *name, CompOptionValue *value)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, ColorfilterScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ColorfilterScreenOptionFilters:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ColorfilterScreenOptionFilters])
                (*os->notify[ColorfilterScreenOptionFilters]) (s, o, ColorfilterScreenOptionFilters);
            return TRUE;
        }
        break;
     case ColorfilterScreenOptionFilterDecorations:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ColorfilterScreenOptionFilterDecorations])
                (*os->notify[ColorfilterScreenOptionFilterDecorations]) (s, o, ColorfilterScreenOptionFilterDecorations);
            return TRUE;
        }
        break;
     case ColorfilterScreenOptionFilterMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ColorfilterScreenOptionFilterMatch])
                (*os->notify[ColorfilterScreenOptionFilterMatch]) (s, o, ColorfilterScreenOptionFilterMatch);
            return TRUE;
        }
        break;
     case ColorfilterScreenOptionExcludeMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ColorfilterScreenOptionExcludeMatch])
                (*os->notify[ColorfilterScreenOptionExcludeMatch]) (s, o, ColorfilterScreenOptionExcludeMatch);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * colorfilterOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    COLORFILTER_OPTIONS_SCREEN(s);
    *count = ColorfilterScreenOptionNum;
    return os->opt;
}

static Bool colorfilterOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    ColorfilterOptionsScreen *os;
    
    COLORFILTER_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(ColorfilterOptionsScreen));
    if (!os)
        return FALSE;

    s->privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &colorfilterOptionsMetadata, colorfilterOptionsScreenOptionInfo, os->opt, ColorfilterScreenOptionNum))
    {
        free (os);
        return FALSE;
    }
    if (colorfilterPluginVTable && colorfilterPluginVTable->initScreen)
        return colorfilterPluginVTable->initScreen (p, s);
    return TRUE;
}

static void colorfilterOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    if (colorfilterPluginVTable && colorfilterPluginVTable->finiScreen)
        return colorfilterPluginVTable->finiScreen (p, s);

    COLORFILTER_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, ColorfilterScreenOptionNum);

    free (os);
}

static Bool colorfilterOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    ColorfilterOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(ColorfilterOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->privates[displayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &colorfilterOptionsMetadata, colorfilterOptionsDisplayOptionInfo, od->opt, ColorfilterDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }
    if (colorfilterPluginVTable && colorfilterPluginVTable->initDisplay)
        return colorfilterPluginVTable->initDisplay (p, d);
    return TRUE;
}

static void colorfilterOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    if (colorfilterPluginVTable && colorfilterPluginVTable->finiDisplay)
        return colorfilterPluginVTable->finiDisplay (p, d);

    COLORFILTER_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, ColorfilterDisplayOptionNum);

    free (od);
}

static Bool colorfilterOptionsInit (CompPlugin *p)
{
    displayPrivateIndex = allocateDisplayPrivateIndex();
    if (displayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&colorfilterOptionsMetadata, "colorfilter",colorfilterOptionsDisplayOptionInfo, ColorfilterDisplayOptionNum, colorfilterOptionsScreenOptionInfo, ColorfilterScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&colorfilterOptionsMetadata, "colorfilter");
    if (colorfilterPluginVTable && colorfilterPluginVTable->init)
        return colorfilterPluginVTable->init (p);
    return TRUE;
}

static void colorfilterOptionsFini (CompPlugin *p)
{
    if (colorfilterPluginVTable && colorfilterPluginVTable->fini)
        return colorfilterPluginVTable->fini (p);

    if (displayPrivateIndex >= 0)
        freeDisplayPrivateIndex(displayPrivateIndex);

    compFiniMetadata (&colorfilterOptionsMetadata);
}

static CompMetadata *
colorfilterOptionsGetMetadata (CompPlugin *plugin)
{
    return &colorfilterOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo (void)
{
    if (!colorfilterPluginVTable)
    {
        colorfilterPluginVTable = colorfilterOptionsGetCompPluginInfo ();
        memcpy(&colorfilterOptionsVTable, colorfilterPluginVTable, sizeof(CompPluginVTable));
        colorfilterOptionsVTable.getMetadata = colorfilterOptionsGetMetadata;
        colorfilterOptionsVTable.init = colorfilterOptionsInit;
        colorfilterOptionsVTable.fini = colorfilterOptionsFini;
        colorfilterOptionsVTable.initDisplay = colorfilterOptionsInitDisplay;
        colorfilterOptionsVTable.finiDisplay = colorfilterOptionsFiniDisplay;
        colorfilterOptionsVTable.initScreen = colorfilterOptionsInitScreen;
        colorfilterOptionsVTable.finiScreen = colorfilterOptionsFiniScreen;
        colorfilterOptionsVTable.getDisplayOptions = colorfilterOptionsGetDisplayOptions;
	colorfilterOptionsVTable.setDisplayOption = colorfilterOptionsSetDisplayOption;
	colorfilterOptionsVTable.getScreenOptions = colorfilterOptionsGetScreenOptions;
	colorfilterOptionsVTable.setScreenOption = colorfilterOptionsSetScreenOption;
	
    }
    return &colorfilterOptionsVTable;
}

