/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz.h>

#define _EXTRAWM_OPTIONS_INTERNAL
#include "extrawm_options.h"

static int displayPrivateIndex;

static CompMetadata extrawmOptionsMetadata;

static CompPluginVTable *extrawmPluginVTable = NULL;
CompPluginVTable extrawmOptionsVTable;

#define GET_EXTRAWM_OPTIONS_DISPLAY(d) \
        ((ExtrawmOptionsDisplay *) (d)->privates[displayPrivateIndex].ptr)

#define EXTRAWM_OPTIONS_DISPLAY(d) \
        ExtrawmOptionsDisplay *od = GET_EXTRAWM_OPTIONS_DISPLAY (d)

#define GET_EXTRAWM_OPTIONS_SCREEN(s, od) \
        ((ExtrawmOptionsScreen *) (s)->privates[(od)->screenPrivateIndex].ptr)

#define EXTRAWM_OPTIONS_SCREEN(s) \
        ExtrawmOptionsScreen *os = GET_EXTRAWM_OPTIONS_SCREEN (s, GET_EXTRAWM_OPTIONS_DISPLAY (s->display))

typedef struct _ExtrawmOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[ExtrawmDisplayOptionNum];
    extrawmDisplayOptionChangeNotifyProc notify[ExtrawmDisplayOptionNum];
} ExtrawmOptionsDisplay;

typedef struct _ExtrawmOptionsScreen
{
} ExtrawmOptionsScreen;

CompAction * extrawmGetActivate (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionActivate].value.action;
}

void extrawmSetActivateInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionActivate].value.action.initiate = init;
}

void extrawmSetActivateTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionActivate].value.action.terminate = term;
}

CompOption * extrawmGetActivateOption (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionActivate];
}

void extrawmSetActivateNotify (CompDisplay *d, extrawmDisplayOptionChangeNotifyProc notify)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->notify[ExtrawmDisplayOptionActivate] = notify;
}

CompAction * extrawmGetToggleRedirect (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionToggleRedirect].value.action;
}

void extrawmSetToggleRedirectInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionToggleRedirect].value.action.initiate = init;
}

void extrawmSetToggleRedirectTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionToggleRedirect].value.action.terminate = term;
}

CompOption * extrawmGetToggleRedirectOption (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionToggleRedirect];
}

void extrawmSetToggleRedirectNotify (CompDisplay *d, extrawmDisplayOptionChangeNotifyProc notify)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->notify[ExtrawmDisplayOptionToggleRedirect] = notify;
}

CompAction * extrawmGetToggleFullscreen (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionToggleFullscreen].value.action;
}

void extrawmSetToggleFullscreenInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionToggleFullscreen].value.action.initiate = init;
}

void extrawmSetToggleFullscreenTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionToggleFullscreen].value.action.terminate = term;
}

CompOption * extrawmGetToggleFullscreenOption (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionToggleFullscreen];
}

void extrawmSetToggleFullscreenNotify (CompDisplay *d, extrawmDisplayOptionChangeNotifyProc notify)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->notify[ExtrawmDisplayOptionToggleFullscreen] = notify;
}

CompAction * extrawmGetToggleAlwaysOnTop (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionToggleAlwaysOnTop].value.action;
}

void extrawmSetToggleAlwaysOnTopInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionToggleAlwaysOnTop].value.action.initiate = init;
}

void extrawmSetToggleAlwaysOnTopTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionToggleAlwaysOnTop].value.action.terminate = term;
}

CompOption * extrawmGetToggleAlwaysOnTopOption (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionToggleAlwaysOnTop];
}

void extrawmSetToggleAlwaysOnTopNotify (CompDisplay *d, extrawmDisplayOptionChangeNotifyProc notify)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->notify[ExtrawmDisplayOptionToggleAlwaysOnTop] = notify;
}

CompAction * extrawmGetToggleSticky (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionToggleSticky].value.action;
}

void extrawmSetToggleStickyInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionToggleSticky].value.action.initiate = init;
}

void extrawmSetToggleStickyTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->opt[ExtrawmDisplayOptionToggleSticky].value.action.terminate = term;
}

CompOption * extrawmGetToggleStickyOption (CompDisplay *d)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[ExtrawmDisplayOptionToggleSticky];
}

void extrawmSetToggleStickyNotify (CompDisplay *d, extrawmDisplayOptionChangeNotifyProc notify)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    od->notify[ExtrawmDisplayOptionToggleSticky] = notify;
}

CompOption * extrawmGetDisplayOption (CompDisplay *d, ExtrawmDisplayOptions num)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo extrawmOptionsDisplayOptionInfo[] = {
    { "activate", "action", 0, 0, 0 },
    { "toggle_redirect", "action", 0, 0, 0 },
    { "toggle_fullscreen", "action", 0, 0, 0 },
    { "toggle_always_on_top", "action", 0, 0, 0 },
    { "toggle_sticky", "action", 0, 0, 0 },
};

static Bool extrawmOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, char *name, CompOptionValue *value)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, ExtrawmDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ExtrawmDisplayOptionActivate:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExtrawmDisplayOptionActivate])
                (*od->notify[ExtrawmDisplayOptionActivate]) (d, o, ExtrawmDisplayOptionActivate);
            return TRUE;
        }
        break;
     case ExtrawmDisplayOptionToggleRedirect:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExtrawmDisplayOptionToggleRedirect])
                (*od->notify[ExtrawmDisplayOptionToggleRedirect]) (d, o, ExtrawmDisplayOptionToggleRedirect);
            return TRUE;
        }
        break;
     case ExtrawmDisplayOptionToggleFullscreen:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExtrawmDisplayOptionToggleFullscreen])
                (*od->notify[ExtrawmDisplayOptionToggleFullscreen]) (d, o, ExtrawmDisplayOptionToggleFullscreen);
            return TRUE;
        }
        break;
     case ExtrawmDisplayOptionToggleAlwaysOnTop:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExtrawmDisplayOptionToggleAlwaysOnTop])
                (*od->notify[ExtrawmDisplayOptionToggleAlwaysOnTop]) (d, o, ExtrawmDisplayOptionToggleAlwaysOnTop);
            return TRUE;
        }
        break;
     case ExtrawmDisplayOptionToggleSticky:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ExtrawmDisplayOptionToggleSticky])
                (*od->notify[ExtrawmDisplayOptionToggleSticky]) (d, o, ExtrawmDisplayOptionToggleSticky);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * extrawmOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    EXTRAWM_OPTIONS_DISPLAY(d);
    *count = ExtrawmDisplayOptionNum;
    return od->opt;
}

static Bool extrawmOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    ExtrawmOptionsScreen *os;
    
    EXTRAWM_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(ExtrawmOptionsScreen));
    if (!os)
        return FALSE;

    s->privates[od->screenPrivateIndex].ptr = os;

        if (extrawmPluginVTable && extrawmPluginVTable->initScreen)
        return extrawmPluginVTable->initScreen (p, s);
    return TRUE;
}

static void extrawmOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    if (extrawmPluginVTable && extrawmPluginVTable->finiScreen)
        return extrawmPluginVTable->finiScreen (p, s);

    EXTRAWM_OPTIONS_SCREEN (s);

    free (os);
}

static Bool extrawmOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    ExtrawmOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(ExtrawmOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->privates[displayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &extrawmOptionsMetadata, extrawmOptionsDisplayOptionInfo, od->opt, ExtrawmDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }
    if (extrawmPluginVTable && extrawmPluginVTable->initDisplay)
        return extrawmPluginVTable->initDisplay (p, d);
    return TRUE;
}

static void extrawmOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    if (extrawmPluginVTable && extrawmPluginVTable->finiDisplay)
        return extrawmPluginVTable->finiDisplay (p, d);

    EXTRAWM_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, ExtrawmDisplayOptionNum);

    free (od);
}

static Bool extrawmOptionsInit (CompPlugin *p)
{
    displayPrivateIndex = allocateDisplayPrivateIndex();
    if (displayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&extrawmOptionsMetadata, "extrawm",extrawmOptionsDisplayOptionInfo, ExtrawmDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&extrawmOptionsMetadata, "extrawm");
    if (extrawmPluginVTable && extrawmPluginVTable->init)
        return extrawmPluginVTable->init (p);
    return TRUE;
}

static void extrawmOptionsFini (CompPlugin *p)
{
    if (extrawmPluginVTable && extrawmPluginVTable->fini)
        return extrawmPluginVTable->fini (p);

    if (displayPrivateIndex >= 0)
        freeDisplayPrivateIndex(displayPrivateIndex);

    compFiniMetadata (&extrawmOptionsMetadata);
}

static CompMetadata *
extrawmOptionsGetMetadata (CompPlugin *plugin)
{
    return &extrawmOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo (void)
{
    if (!extrawmPluginVTable)
    {
        extrawmPluginVTable = extrawmOptionsGetCompPluginInfo ();
        memcpy(&extrawmOptionsVTable, extrawmPluginVTable, sizeof(CompPluginVTable));
        extrawmOptionsVTable.getMetadata = extrawmOptionsGetMetadata;
        extrawmOptionsVTable.init = extrawmOptionsInit;
        extrawmOptionsVTable.fini = extrawmOptionsFini;
        extrawmOptionsVTable.initDisplay = extrawmOptionsInitDisplay;
        extrawmOptionsVTable.finiDisplay = extrawmOptionsFiniDisplay;
        extrawmOptionsVTable.initScreen = extrawmOptionsInitScreen;
        extrawmOptionsVTable.finiScreen = extrawmOptionsFiniScreen;
        extrawmOptionsVTable.getDisplayOptions = extrawmOptionsGetDisplayOptions;
	extrawmOptionsVTable.setDisplayOption = extrawmOptionsSetDisplayOption;
	
    }
    return &extrawmOptionsVTable;
}

