/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz.h>

#define _CRASHHANDLER_OPTIONS_INTERNAL
#include "crashhandler_options.h"

static int displayPrivateIndex;

static CompMetadata crashhandlerOptionsMetadata;

static CompPluginVTable *crashhandlerPluginVTable = NULL;
CompPluginVTable crashhandlerOptionsVTable;

#define GET_CRASHHANDLER_OPTIONS_DISPLAY(d) \
        ((CrashhandlerOptionsDisplay *) (d)->privates[displayPrivateIndex].ptr)

#define CRASHHANDLER_OPTIONS_DISPLAY(d) \
        CrashhandlerOptionsDisplay *od = GET_CRASHHANDLER_OPTIONS_DISPLAY (d)

#define GET_CRASHHANDLER_OPTIONS_SCREEN(s, od) \
        ((CrashhandlerOptionsScreen *) (s)->privates[(od)->screenPrivateIndex].ptr)

#define CRASHHANDLER_OPTIONS_SCREEN(s) \
        CrashhandlerOptionsScreen *os = GET_CRASHHANDLER_OPTIONS_SCREEN (s, GET_CRASHHANDLER_OPTIONS_DISPLAY (s->display))

typedef struct _CrashhandlerOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[CrashhandlerDisplayOptionNum];
    crashhandlerDisplayOptionChangeNotifyProc notify[CrashhandlerDisplayOptionNum];
} CrashhandlerOptionsDisplay;

typedef struct _CrashhandlerOptionsScreen
{
} CrashhandlerOptionsScreen;

Bool crashhandlerGetEnabled (CompDisplay *d)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    return od->opt[CrashhandlerDisplayOptionEnabled].value.b;
}

CompOption * crashhandlerGetEnabledOption (CompDisplay *d)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    return &od->opt[CrashhandlerDisplayOptionEnabled];
}

void crashhandlerSetEnabledNotify (CompDisplay *d, crashhandlerDisplayOptionChangeNotifyProc notify)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    od->notify[CrashhandlerDisplayOptionEnabled] = notify;
}

Bool crashhandlerGetStartWm (CompDisplay *d)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    return od->opt[CrashhandlerDisplayOptionStartWm].value.b;
}

CompOption * crashhandlerGetStartWmOption (CompDisplay *d)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    return &od->opt[CrashhandlerDisplayOptionStartWm];
}

void crashhandlerSetStartWmNotify (CompDisplay *d, crashhandlerDisplayOptionChangeNotifyProc notify)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    od->notify[CrashhandlerDisplayOptionStartWm] = notify;
}

char * crashhandlerGetWmCmd (CompDisplay *d)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    return od->opt[CrashhandlerDisplayOptionWmCmd].value.s;
}

CompOption * crashhandlerGetWmCmdOption (CompDisplay *d)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    return &od->opt[CrashhandlerDisplayOptionWmCmd];
}

void crashhandlerSetWmCmdNotify (CompDisplay *d, crashhandlerDisplayOptionChangeNotifyProc notify)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    od->notify[CrashhandlerDisplayOptionWmCmd] = notify;
}

CompOption * crashhandlerGetDisplayOption (CompDisplay *d, CrashhandlerDisplayOptions num)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo crashhandlerOptionsDisplayOptionInfo[] = {
    { "enabled", "bool", 0, 0, 0 },
    { "start_wm", "bool", 0, 0, 0 },
    { "wm_cmd", "string", 0, 0, 0 },
};

static Bool crashhandlerOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, char *name, CompOptionValue *value)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, CrashhandlerDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case CrashhandlerDisplayOptionEnabled:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CrashhandlerDisplayOptionEnabled])
                (*od->notify[CrashhandlerDisplayOptionEnabled]) (d, o, CrashhandlerDisplayOptionEnabled);
            return TRUE;
        }
        break;
     case CrashhandlerDisplayOptionStartWm:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CrashhandlerDisplayOptionStartWm])
                (*od->notify[CrashhandlerDisplayOptionStartWm]) (d, o, CrashhandlerDisplayOptionStartWm);
            return TRUE;
        }
        break;
     case CrashhandlerDisplayOptionWmCmd:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CrashhandlerDisplayOptionWmCmd])
                (*od->notify[CrashhandlerDisplayOptionWmCmd]) (d, o, CrashhandlerDisplayOptionWmCmd);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * crashhandlerOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    *count = CrashhandlerDisplayOptionNum;
    return od->opt;
}

static Bool crashhandlerOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    CrashhandlerOptionsScreen *os;
    
    CRASHHANDLER_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(CrashhandlerOptionsScreen));
    if (!os)
        return FALSE;

    s->privates[od->screenPrivateIndex].ptr = os;

        if (crashhandlerPluginVTable && crashhandlerPluginVTable->initScreen)
        return crashhandlerPluginVTable->initScreen (p, s);
    return TRUE;
}

static void crashhandlerOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    if (crashhandlerPluginVTable && crashhandlerPluginVTable->finiScreen)
        return crashhandlerPluginVTable->finiScreen (p, s);

    CRASHHANDLER_OPTIONS_SCREEN (s);

    free (os);
}

static Bool crashhandlerOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    CrashhandlerOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(CrashhandlerOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->privates[displayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &crashhandlerOptionsMetadata, crashhandlerOptionsDisplayOptionInfo, od->opt, CrashhandlerDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }
    if (crashhandlerPluginVTable && crashhandlerPluginVTable->initDisplay)
        return crashhandlerPluginVTable->initDisplay (p, d);
    return TRUE;
}

static void crashhandlerOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    if (crashhandlerPluginVTable && crashhandlerPluginVTable->finiDisplay)
        return crashhandlerPluginVTable->finiDisplay (p, d);

    CRASHHANDLER_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, CrashhandlerDisplayOptionNum);

    free (od);
}

static Bool crashhandlerOptionsInit (CompPlugin *p)
{
    displayPrivateIndex = allocateDisplayPrivateIndex();
    if (displayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&crashhandlerOptionsMetadata, "crashhandler",crashhandlerOptionsDisplayOptionInfo, CrashhandlerDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&crashhandlerOptionsMetadata, "crashhandler");
    if (crashhandlerPluginVTable && crashhandlerPluginVTable->init)
        return crashhandlerPluginVTable->init (p);
    return TRUE;
}

static void crashhandlerOptionsFini (CompPlugin *p)
{
    if (crashhandlerPluginVTable && crashhandlerPluginVTable->fini)
        return crashhandlerPluginVTable->fini (p);

    if (displayPrivateIndex >= 0)
        freeDisplayPrivateIndex(displayPrivateIndex);

    compFiniMetadata (&crashhandlerOptionsMetadata);
}

static CompMetadata *
crashhandlerOptionsGetMetadata (CompPlugin *plugin)
{
    return &crashhandlerOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo (void)
{
    if (!crashhandlerPluginVTable)
    {
        crashhandlerPluginVTable = crashhandlerOptionsGetCompPluginInfo ();
        memcpy(&crashhandlerOptionsVTable, crashhandlerPluginVTable, sizeof(CompPluginVTable));
        crashhandlerOptionsVTable.getMetadata = crashhandlerOptionsGetMetadata;
        crashhandlerOptionsVTable.init = crashhandlerOptionsInit;
        crashhandlerOptionsVTable.fini = crashhandlerOptionsFini;
        crashhandlerOptionsVTable.initDisplay = crashhandlerOptionsInitDisplay;
        crashhandlerOptionsVTable.finiDisplay = crashhandlerOptionsFiniDisplay;
        crashhandlerOptionsVTable.initScreen = crashhandlerOptionsInitScreen;
        crashhandlerOptionsVTable.finiScreen = crashhandlerOptionsFiniScreen;
        crashhandlerOptionsVTable.getDisplayOptions = crashhandlerOptionsGetDisplayOptions;
	crashhandlerOptionsVTable.setDisplayOption = crashhandlerOptionsSetDisplayOption;
	
    }
    return &crashhandlerOptionsVTable;
}

