#! /usr/bin/env python3

from setuptools import setup
import re

# We probably ought to use debian.changelog, but let's avoid that
# dependency for now.
changelog_heading = re.compile(r"\w[-+0-9a-z.]* \(([^\(\) \t]+)\)")

with open("debian/changelog") as changelog:
    line = changelog.readline()
    match = changelog_heading.match(line)
    if match is None:
        raise ValueError("Failed to parse first line of debian/changelog: "
                         "'%s'" % line)
    version = match.group(1)


setup(
    name="apparmor.click",
    namespace_packages=['apparmor'],
    version=version,
    description="AppArmor click utility",
    author="Steve Beattie",
    author_email="steve.beattie@canonical.com",
    license="GNU GPL-2",
    scripts=['aa-clicktool', 'aa-clickhook', 'aa-clickquery',
             'aa-profile-hook'],
    # packages=['apparmor'],
    py_modules=['apparmor.click'],
    package_dir = {'':'src'},
)
