/*
 * @file detecttest.c
 * @brief Simple tester for the keyboard selection file interpreter
 */
#include <stdio.h>
#include <stdlib.h>
#include "common.h"
#include "debconf.h"
#include "detect_keys.h"

int test_press_key(struct frontend *obj, char *syms, int *codes, int *result)
{
	int *i;
	char s[20];
	printf("Please press one of these keys: %s\n",syms);
	printf("Please return one of these codes:");
	for(i=codes;*i!=-1;i++)
		printf(" %i",*i);
	printf("\nCode: ");

 	*s='\0';
 	fgets(s,sizeof(s)-1,stdin);
	if(!*s) return DC_NOTOK;
	*result = atoi(s);
	return DC_OK;
}

int test_key_there(struct frontend *obj, char *sym, bool *result)
{
	char s[20];
	printf("Is there a key labelled '%s'? ",sym);
 	fgets(s,sizeof(s)-1,stdin);
	if(!*s) return DC_NOTOK;
	*result = !(*s == 'n' || *s == 'N');
	return DC_OK;
}

struct detect_keys_frontend dkf = {
	press_key: test_press_key,
	is_key_there: test_key_there
};

int main(int argc, char *argv[]) {
	int res;
	struct frontend *obj = NULL;
	char *result;

	setenv("DEBCONF_DEBUG","99",1);
	if(argc > 2) {
		fprintf(stderr,"Usage: %s file\n",argv[0]);
		exit(1);
	}

	result=NULL;
	res = detect_keys(obj, &dkf, (argc==2)?argv[1]:"detecttest.data", &result);
	if(res == DC_OK) {
		printf("The map is: %s\n",result);
		exit(0);
	} else {
		fprintf(stderr,"Problem: %d\n",res);
		exit(1);
	}
}


