#!/usr/bin/env python
import os
import re
from subprocess import call, PIPE
import sys

sys.path.insert(0, '..')
sys.path.insert(0, os.path.dirname(os.path.realpath('/home/abentley/bin/bzr')))
import bzrtools
print "bzrtools version: %s" % bzrtools.__version__
def minigrep(pattern, filename):
    setup = open(filename, 'rb')
    for line in setup:
        match = re.search(pattern, line)
        if match is not None:
            return match

newsmatch = minigrep('RELEASE: bzrtools %s' % (bzrtools.__version__), 'NEWS')
if newsmatch is None:
    print "NEWS entry missing"
    sys.exit(1)
else:
    print "NEWS entry found"
final_name = '../bzrtools-release/bzrtools-%s.tar.gz' % bzrtools.__version__
if os.path.exists('../bzrtools.tar.gz'):
    print "Temp file exists already."
    sys.exit(1)
if os.path.exists(final_name):
    print "Final file exists already."
    sys.exit(1)
if call(['bzr', 'diff'], stdout=PIPE) != 0:
    print "Please commit before releasing"
    sys.exit(1)
retcode = call(['bzr', 'tag', 'release-%s' % bzrtools.__version__])
if retcode != 0:
    sys.exit(1)
retcode = call(['bzr', 'export', '../bzrtools.tar.gz'])
if retcode != 0:
    sys.exit(1)
os.rename('../bzrtools.tar.gz', final_name)
print 'Created %s' % final_name
call(['gpg', '--detach-sign', final_name])
#print 'Uploading...'
#call(['scp', final_name, final_name + '.sig',
#      'panoramicfeedback.com:opensource/'])
