import os.path

from bzrlib import add, tests
from bzrlib.plugins.bzrtools.bzrtools import is_clean

class TestIsClean(tests.TestCaseWithTransport):
    
    def test_is_clean(self):
        tree = self.make_branch_and_tree('.')
        self.assertEqual((True, []), is_clean(tree))
        fooname = os.path.join(tree.basedir, "foo")
        file(fooname, "wb").write("bar")
        self.assertEqual((True, [u'foo']), is_clean(tree))
        add.smart_add_tree(tree, [tree.basedir])
        self.assertEqual((False, []), is_clean(tree))
        tree.commit("added file", rev_id='commit-id')
        self.assertEqual((True, []), is_clean(tree))
