/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2005-2008  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib/gi18n.h>

#include <gtk/gtk.h>

#include "bluetooth-device-selection.h"

#include "dialog.h"

static void selected_device_changed(BluetoothDeviceSelection *selector,
					gchar *address, gpointer user_data)
{
	GtkWidget *dialog = user_data;

	gtk_dialog_set_response_sensitive(GTK_DIALOG(dialog),
				GTK_RESPONSE_ACCEPT, address != NULL);
}

gchar *show_browse_dialog(void)
{
	GtkWidget *dialog;
	GtkWidget *selector;
	gchar *address = NULL;

	dialog = gtk_dialog_new_with_buttons(_("Select Device"),
				NULL, GTK_DIALOG_NO_SEPARATOR,
				GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT,
				GTK_STOCK_CONNECT, GTK_RESPONSE_ACCEPT, NULL);

	gtk_dialog_set_response_sensitive(GTK_DIALOG(dialog),
						GTK_RESPONSE_ACCEPT, FALSE);

	gtk_window_set_default_size(GTK_WINDOW(dialog), 450, 400);

	gtk_container_set_border_width(GTK_CONTAINER(dialog), 5);
	gtk_box_set_spacing(GTK_BOX(GTK_DIALOG(dialog)->vbox), 2);

	selector = bluetooth_device_selection_new(_("Select destination device"));
	gtk_container_set_border_width(GTK_CONTAINER(selector), 5);

	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), selector);

	g_signal_connect(selector, "selected-device-changed",
				G_CALLBACK(selected_device_changed), dialog);

	gtk_widget_show_all(selector);

	g_object_set(selector, "show-search", FALSE, NULL);

	bluetooth_device_selection_start_discovery(BLUETOOTH_DEVICE_SELECTION(selector));

	if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT)
		g_object_get(selector, "device-selected", &address, NULL);

	gtk_widget_destroy(dialog);

	return address;
}

GSList *show_select_dialog(void)
{
	GtkWidget *dialog;
	GSList *filenames = NULL;

	dialog = gtk_file_chooser_dialog_new(_("Choose files to send"), NULL,
				GTK_FILE_CHOOSER_ACTION_OPEN,
				GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);

	gtk_file_chooser_set_select_multiple(GTK_FILE_CHOOSER(dialog), FALSE);

	if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT)
		filenames = gtk_file_chooser_get_filenames(GTK_FILE_CHOOSER(dialog));

	gtk_widget_destroy(dialog);

	return filenames;
}
