/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2005-2007  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

struct l2cap_packet_hdr {
	guint16 len;
	guint16 cid;
} __attribute__ ((packed));
#define L2CAP_PACKET_HDR_SIZE 4

struct l2cap_command_hdr {
	guint8  code;
	guint8  ident;
	guint16 len;
} __attribute__ ((packed));
#define L2CAP_COMMAND_HDR_SIZE 4

struct l2cap_connect_req {
	guint16 psm;
	guint16 scid;
} __attribute__ ((packed));
#define L2CAP_CONNECT_REQ_SIZE 4

struct l2cap_connect_rsp {
	guint16 dcid;
	guint16 scid;
	guint16 result;
	guint16 status;
} __attribute__ ((packed));
#define L2CAP_CONNECT_RSP_SIZE 8

struct l2cap_disconnect_req {
	guint16 dcid;
	guint16 scid;
} __attribute__ ((packed));
#define L2CAP_DISCONNECT_REQ_SIZE 4

struct l2cap_disconnect_rsp {
	guint16 dcid;
	guint16 scid;
} __attribute__ ((packed));
#define L2CAP_DISCONNET_RSP_SIZE 4

void analyze_l2cap(GtkTreeStore *store);

gchar *decode_l2cap(guint handle, guint psm, gpointer data, guint size);
