/**
 * $Id: BSP_FragTree.h,v 1.7 2005/10/28 20:18:56 intrr Exp $
 * ***** BEGIN GPL/BL DUAL LICENSE BLOCK *****
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. The Blender
 * Foundation also sells licenses for use in proprietary software under
 * the Blender License.  See http://www.blender.org/BL/ for information
 * about this.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * The Original Code is Copyright (C) 2001-2002 by NaN Holding BV.
 * All rights reserved.
 *
 * The Original Code is: all of this file.
 *
 * Contributor(s): none yet.
 *
 * ***** END GPL/BL DUAL LICENSE BLOCK *****
 */

#ifndef BSP_FragTree_h
#define BSP_FragTree_h

class BSP_FragNode;

#include "MEM_SmartPtr.h"
#include "MEM_NonCopyable.h"
#include "BSP_MeshPrimitives.h"

class BSP_CSGMesh;
class BSP_MeshFragment;
class BSP_CSGISplitter;

class BSP_FragTree : public MEM_NonCopyable
{
public :

	/**
	 * Create a new BSP_FragTree allocated
	 * on the heap for mesh. Note mesh will 
	 * be divided up by this operation. If you
	 * want to retain the original mesh make a copy 
	 * of it first.
	 */
	
	static
		MEM_SmartPtr<BSP_FragTree>
	New(
		BSP_CSGMesh *mesh,
		BSP_CSGISplitter & splitter
	);
	

	/**
	 * Push a mesh fragment down the tree,
	 * splitting the mesh as it goes. 
	 * upon reaching leaves it puts polygons from fragments
	 * of type keep into the output fragment.
	 */

		void
	Push(
		BSP_MeshFragment *in_frag,
		BSP_MeshFragment *output,
		const BSP_Classification keep,
		const BSP_Classification current,
		const bool dominant,
		BSP_CSGISplitter & splitter
	); 

		void
	Classify(
		BSP_CSGMesh *mesh,
		BSP_MeshFragment *in_frag,
		BSP_MeshFragment *out_frag,
		BSP_MeshFragment *on_frag,
		BSP_CSGISplitter & splitter
	);


	~BSP_FragTree(
	);

private :

	friend class BSP_FragNode;

	BSP_FragTree(
	);

	BSP_FragTree(
		BSP_CSGMesh *mesh
	);

		void
	Build(
		BSP_MeshFragment * frag,
		BSP_CSGISplitter & splitter
	);


		void
	Classify(
		BSP_MeshFragment * frag,
		BSP_MeshFragment *in_frag,
		BSP_MeshFragment *out_frag,
		BSP_MeshFragment *on_frag,
		const BSP_Classification current,
		BSP_CSGISplitter & splitter
	);

private :

	/**
	 * pointer to the mesh for this tree.
	 * Tree is only valid whilst mesh is around.
	 */

	BSP_CSGMesh *m_mesh;
	
	/**
	 * The node owned by this tree.
	 */

	MEM_SmartPtr<BSP_FragNode> m_node;
	
};

#endif

