/* unit-apply-changeset.c
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005, Canonical Limited
 *               Author: Robert Collins
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/vu/reserv.h"
#include "hackerlab/bugs/panic.h"
#include "hackerlab/char/str.h"
#include "hackerlab/vu/safe.h"
#include "hackerlab/mem/mem.h"
#include "libarch/apply-changeset.h"


/* typedefs */



/* local methods */
/* Move to hackerlab */
static void
invariant_str_cmp(t_uchar const *left, t_uchar const *right)
{
    if (str_cmp (left, right))
      {
	safe_printfmt (2, "assertion failed: '%s' != '%s'\n", left, right);
	exit (1);
      }
}

static void
rambling_test(void)
{
  t_uchar *orig, *rej;
  struct running_inventory_assocs inventory;

  conflict_filenames("", "foo", &orig, &rej, NULL);
  invariant_str_cmp ("foo.orig", orig);
  invariant_str_cmp ("foo.rej", rej);
  lim_free (0, orig);
  lim_free (0, rej);

  conflict_filenames(".", "foo", &orig, NULL, NULL);
  invariant_str_cmp ("foo.orig", orig);
  lim_free (0, orig);
  
  conflict_filenames(".", "foo", NULL, &rej, NULL);
  invariant_str_cmp ("foo.rej", rej);
  lim_free (0, rej);
  
  mem_set0 ((t_uchar *)&inventory, sizeof (inventory));

  assoc_set (&inventory.dir_id_of, "./adir", "adirid");
  assoc_set (&inventory.dir_id_of, "./adir.orig", "adirid1");
  assoc_set (&inventory.dir_id_of, "./anotherdir", "adirid2");
  assoc_set (&inventory.file_id_of, "./afile", "afileid");
  assoc_set (&inventory.file_id_of, "./afile.orig", "afileid1");
  assoc_set (&inventory.file_id_of, "./anotherfile", "afileid2");

  conflict_filenames(".", "././adir", &orig, &rej, &inventory);
  invariant_str_cmp ("././adir,.orig", orig);
  invariant_str_cmp ("././adir,.rej", rej);
  lim_free (0, orig);
  lim_free (0, rej);
  
  conflict_filenames(".", "././anotherdir", &orig, &rej, &inventory);
  invariant_str_cmp ("././anotherdir.orig", orig);
  invariant_str_cmp ("././anotherdir.rej", rej);
  lim_free (0, orig);
  lim_free (0, rej);


  conflict_filenames(".", "././afile", &orig, &rej, &inventory);
  invariant_str_cmp ("././afile,.orig", orig);
  invariant_str_cmp ("././afile,.rej", rej);
  lim_free (0, orig);
  lim_free (0, rej);

  conflict_filenames(".", "././anotherfile", &orig, &rej, &inventory);
  invariant_str_cmp ("././anotherfile.orig", orig);
  invariant_str_cmp ("././anotherfile.rej", rej);
  lim_free (0, orig);
  lim_free (0, rej);
}

int
main (int argc, char * argv[])
{
  rambling_test();

  return 0;
}

