/* inode-sig.h:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__INODE_SIG_H
#define INCLUDE__LIBARCH__INODE_SIG_H


#include "libawk/relational.h"
#include "libawk/associative.h"

struct inode_sig_val {
    rel_table ids;
    rel_table paths;
};

typedef struct inode_sig_val inode_sig;


/* automatically generated __STDC__ prototypes */
extern t_uchar * arch_statb_inode_sig (struct stat * statb);
extern inode_sig arch_tree_inode_sig (t_uchar * tree_root);
extern void arch_snap_inode_sig (t_uchar * tree_root, t_uchar * archive, t_uchar * revision);
extern void arch_snap_inode_sig_files (t_uchar * tree_root, t_uchar * archive, t_uchar * prev_revision, t_uchar * revision, rel_table file_list);
extern int arch_valid_inode_sig (t_uchar * tree_root, t_uchar *archive, t_uchar *revision);
extern void arch_read_inode_sig_ids (rel_table * as_table, assoc_table * as_assoc,
                                     t_uchar * tree_root, t_uchar * archive, t_uchar * revision);
extern void arch_read_id_shortcut (assoc_table * tags_shortcut, t_uchar * tree_root);
extern void arch_inode_sig_free (inode_sig);
#endif  /* INCLUDE__LIBARCH__INODE_SIG_H */


/* tag: Tom Lord Fri Sep 12 10:33:59 2003 (inode-sig.h)
 */
