/* proj-tree-lint.h:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__CONFLICT__HANDLING_H
#define INCLUDE__LIBARCH__CONFLICT__HANDLING_H 


#include "libarch/proj-tree-lint.h"



enum arch_conflict_problems
{
  NO_LONGER_CONFLICTED = 1,
  NOTHING_CHANGED = 2,
  FS_PROBLEM = 4,
  TREE_PROBLEM = 8,
  CONFLICTS_REMOVED = 16,
  UNLISTED_FILE = 32,
};
extern void arch_tree_ensure_no_conflicts ( t_uchar * maybe_tree_root);
extern int  arch_tree_conflicts_exist ( t_uchar * maybe_tree_root);
extern void  arch_tree_note_conflicts (t_uchar * maybe_tree_root,
                                     struct arch_apply_changeset_report * r);
extern int  arch_tree_clear_conflicts ( t_uchar * maybe_tree_root);
extern int arch_tree_show_conflicts (t_uchar * program_name,
                                   t_uchar * maybe_tree_root,
                                   rel_table * output);
extern int arch_tree_unconflict_files (t_uchar * program_name,
                                       t_uchar * maybe_tree_root,
                                       rel_table filenames);




#endif  /* INCLUDE__LIBARCH__CONFLICT__HANDLING_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (conflict-handling.h)
 */
