// aptitude.h
//
//  Copyright 2000 Masato Taruishi <taru@debian.org>,
//                 Daniel Burrows <dburrows@debian.org>
//
//  common header

#ifndef APTITUDE_H
#define APTITUDE_H

#include "../config.h"

/* Take care of NLS matters.  */

#if HAVE_LOCALE_H
# include <locale.h>
#endif
#if !HAVE_SETLOCALE
# define setlocale(Category, Locale) /* empty */
#endif

#if ENABLE_NLS
# include <libintl.h>
# define _(Text) gettext (Text)
# define N_(Text) Text
#else
# undef bindtextdomain
# define bindtextdomain(Domain, Directory) /* empty */
# undef textdomain
# define textdomain(Domain) /* empty */
# define _(Text) Text
# define N_(Text) Text
# define gettext(Text) Text
# define dgettext(Domain, Text) Text
#endif

// This is used to store the location of the binary as determined by
// argv[0].
extern const char *argv0;

#endif
