// view_changelog.cc
//
//   Copyright 2004 Daniel Burrows

#include <vscreen/vs_pager.h>
#include <vscreen/vs_scrollbar.h>
#include <vscreen/vs_table.h>

#include "download_bar.h"
#include "download_manager.h"
#include "ui.h"

#include <generic/pkg_changelog.h>

#include <sigc++/object_slot.h>

using namespace std;

class pkg_changelog_screen:public vs_file_pager
// Needed to make sure the changelog is properly cleaned up.
{
  pkg_changelog *cl;
public:
  pkg_changelog_screen(pkg_changelog *_cl, vscreen_widget *owner=NULL, int x=0, int y=0, int width=0, int height=0):
    vs_file_pager(_cl->get_filename()),cl(_cl)
  {
  }

  virtual ~pkg_changelog_screen() {delete cl;}
};

void view_changelog(pkgCache::VerIterator ver)
{
  download_manager *widget=gen_download_progress(true,
						 _("Downloading Changelog"),
						 NULL);
  pkg_changelog *cl=get_changelog(ver, widget);
  widget->Complete();
  if(cl)
    {
      char buf[512];
      snprintf(buf, 512, _("ChangeLog of %s"), ver.ParentPkg().Name());

      pkg_changelog_screen *cs=new pkg_changelog_screen(cl);
      vs_table *t=new vs_table;
      vs_scrollbar *s=new vs_scrollbar(vs_scrollbar::VERTICAL);

      cs->location_changed.connect(slot(*s, &vs_scrollbar::set_slider));
      s->scrollbar_interaction.connect(slot(*cs, &pkg_changelog_screen::scroll_page));
      cs->scroll_top();

      t->add_widget_opts(cs, 0, 0, 1, 1, vs_table::EXPAND|vs_table::SHRINK, vs_table::EXPAND);
      t->add_widget_opts(s, 0, 1, 1, 1, 0, vs_table::EXPAND);

      t->show_all();

      insert_main_widget(t, buf, "");
    }
}
