// apt_info_tree.cc
//
//  Copyright 2000-2002 Daniel Burrows

#include "apt_info_tree.h"

#include "generic/apt.h"

#include <sigc++/bind.h>
#include <sigc++/object_slot.h>

apt_info_tree::apt_info_tree(string _package, string _version)
  :package(_package), version(_version)
{
  cache_closed.connect(slot(*this, &apt_info_tree::handle_cache_close));
  cache_reloaded.connect(slot(*this, &apt_info_tree::restore_state));
}

void apt_info_tree::handle_cache_close()
{
  set_root(NULL);
}

void apt_info_tree::restore_state()
{
  pkgCache::PkgIterator pkg=(*apt_cache_file)->FindPkg(package);
  if(pkg.end())
    destroy(); // Oopsie, go away
  else
    {
      pkgCache::VerIterator ver=pkg.VersionList();
      if(!version.empty())
	while(!ver.end() && ver.VerStr()!=version)
	  ++ver;
      if(ver.end() && !version.empty())
	// Our version of the package has vanished, pick any version.
	// (the alternative is to make the widget disappear, which I think is
	// uglier)
	{
	  version="";
	  set_root(setup_new_root(pkg, pkg.VersionList()), true);
	}
      else
	set_root(setup_new_root(pkg, ver), true);
    }
}
