#!/bin/sh

TOPDIR=./
TARGETDIR=./menu-data/
MENU=menu-data-$(date +%Y%m%d).tar.gz
HERE=$PWD

# cleanup
rm -f $MENU
rm -f $TARGETDIR/*.desktop 
rm -f $TARGETDIR/icons/* 

# get and unpack
wget -c http://people.ubuntu.com/~mvo/gnome-app-install/$MENU
(cd $TOPDIR ; tar xzvf $HERE/$MENU )

# post-process
bzr add $TARGETDIR/*.desktop
bzr add $TARGETDIR/icons/*

# update the codec information based on the Packages file output
../main/util/gst-add.py ./menu-data-codecs/*.desktop

../main/util/addPopconData.py -d ./menu-data
../main/util/addPopconData.py -d ./menu-data-additional
../main/util/addPopconData.py -d ./menu-data-firefox
../main/util/addPopconData.py -d ./menu-data-codecs

