# ADSys Documentation

ADSys is the Active Directory Group Policy client for Ubuntu.

ADSys enables system administrators to manage Ubuntu Desktop clients centrally via Microsoft Active Directory. It includes ADMX and ADML templates and allows policies to be applied at boot and login, then refreshed periodically.

It simplifies the task of configuring Ubuntu systems in a Microsoft Active Directory environment. However, it doesn't handle user authentication or initial security policy, which are managed by SSSD/Winbind and PAM.

ADSys is valuable for system administrators who wish to manage Ubuntu Desktop clients in a centralised manner through Microsoft Active Directory.

```{toctree}
:hidden:
tutorial/index
how-to/index
reference/index
explanation/index
```

## In this documentation

````{grid} 1 1 2 2

```{grid-item}
### [Tutorials](tutorial/index)

**Learn about ADSys features** with hands-on tutorials
```

```{grid-item}
### [How-to guides](how-to/index)

**Step-by-step guides** covering key operations and common tasks
```

````

````{grid} 1 1 2 2

```{grid-item}
### [Explanation](explanation/index)

**Discussion and clarification** of key topics
```

```{grid-item}
### [Reference](reference/index)

**Technical information** - specifications, APIs, architecture
```

````

## Project and community

ADSys is a member of the Ubuntu family. It’s an open source project that warmly welcomes community contributions, suggestions, fixes and constructive feedback.

* [Code of conduct](https://ubuntu.com/community/code-of-conduct)
* [Join us in the Ubuntu Community](https://discourse.ubuntu.com/c/desktop/8)
* [Contribute](https://github.com/ubuntu/adsys/blob/main/CONTRIBUTING.md) or [Report an issue](https://github.com/ubuntu/adsys/issues/new)
* [Thinking about using ADSys for your next project? Get in touch!](https://ubuntu.com/contact-us/form?product=generic-contact-us)
* [Licensed under GPL v3](https://github.com/ubuntu/adsys/blob/main/LICENSE)
