// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::error::ErrorDomain;
use crate::translate::*;
use crate::Quark;
use std::fmt;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GChecksumType")]
pub enum ChecksumType {
    #[doc(alias = "G_CHECKSUM_MD5")]
    Md5,
    #[doc(alias = "G_CHECKSUM_SHA1")]
    Sha1,
    #[doc(alias = "G_CHECKSUM_SHA256")]
    Sha256,
    #[doc(alias = "G_CHECKSUM_SHA512")]
    Sha512,
    #[doc(alias = "G_CHECKSUM_SHA384")]
    Sha384,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ChecksumType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ChecksumType::{}",
            match *self {
                Self::Md5 => "Md5",
                Self::Sha1 => "Sha1",
                Self::Sha256 => "Sha256",
                Self::Sha512 => "Sha512",
                Self::Sha384 => "Sha384",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ChecksumType {
    type GlibType = ffi::GChecksumType;

    fn into_glib(self) -> ffi::GChecksumType {
        match self {
            Self::Md5 => ffi::G_CHECKSUM_MD5,
            Self::Sha1 => ffi::G_CHECKSUM_SHA1,
            Self::Sha256 => ffi::G_CHECKSUM_SHA256,
            Self::Sha512 => ffi::G_CHECKSUM_SHA512,
            Self::Sha384 => ffi::G_CHECKSUM_SHA384,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GChecksumType> for ChecksumType {
    unsafe fn from_glib(value: ffi::GChecksumType) -> Self {
        match value {
            ffi::G_CHECKSUM_MD5 => Self::Md5,
            ffi::G_CHECKSUM_SHA1 => Self::Sha1,
            ffi::G_CHECKSUM_SHA256 => Self::Sha256,
            ffi::G_CHECKSUM_SHA512 => Self::Sha512,
            ffi::G_CHECKSUM_SHA384 => Self::Sha384,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GConvertError")]
pub enum ConvertError {
    #[doc(alias = "G_CONVERT_ERROR_NO_CONVERSION")]
    NoConversion,
    #[doc(alias = "G_CONVERT_ERROR_ILLEGAL_SEQUENCE")]
    IllegalSequence,
    #[doc(alias = "G_CONVERT_ERROR_FAILED")]
    Failed,
    #[doc(alias = "G_CONVERT_ERROR_PARTIAL_INPUT")]
    PartialInput,
    #[doc(alias = "G_CONVERT_ERROR_BAD_URI")]
    BadUri,
    #[doc(alias = "G_CONVERT_ERROR_NOT_ABSOLUTE_PATH")]
    NotAbsolutePath,
    #[doc(alias = "G_CONVERT_ERROR_NO_MEMORY")]
    NoMemory,
    #[doc(alias = "G_CONVERT_ERROR_EMBEDDED_NUL")]
    EmbeddedNul,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ConvertError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ConvertError::{}",
            match *self {
                Self::NoConversion => "NoConversion",
                Self::IllegalSequence => "IllegalSequence",
                Self::Failed => "Failed",
                Self::PartialInput => "PartialInput",
                Self::BadUri => "BadUri",
                Self::NotAbsolutePath => "NotAbsolutePath",
                Self::NoMemory => "NoMemory",
                Self::EmbeddedNul => "EmbeddedNul",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ConvertError {
    type GlibType = ffi::GConvertError;

    fn into_glib(self) -> ffi::GConvertError {
        match self {
            Self::NoConversion => ffi::G_CONVERT_ERROR_NO_CONVERSION,
            Self::IllegalSequence => ffi::G_CONVERT_ERROR_ILLEGAL_SEQUENCE,
            Self::Failed => ffi::G_CONVERT_ERROR_FAILED,
            Self::PartialInput => ffi::G_CONVERT_ERROR_PARTIAL_INPUT,
            Self::BadUri => ffi::G_CONVERT_ERROR_BAD_URI,
            Self::NotAbsolutePath => ffi::G_CONVERT_ERROR_NOT_ABSOLUTE_PATH,
            Self::NoMemory => ffi::G_CONVERT_ERROR_NO_MEMORY,
            Self::EmbeddedNul => ffi::G_CONVERT_ERROR_EMBEDDED_NUL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GConvertError> for ConvertError {
    unsafe fn from_glib(value: ffi::GConvertError) -> Self {
        match value {
            ffi::G_CONVERT_ERROR_NO_CONVERSION => Self::NoConversion,
            ffi::G_CONVERT_ERROR_ILLEGAL_SEQUENCE => Self::IllegalSequence,
            ffi::G_CONVERT_ERROR_FAILED => Self::Failed,
            ffi::G_CONVERT_ERROR_PARTIAL_INPUT => Self::PartialInput,
            ffi::G_CONVERT_ERROR_BAD_URI => Self::BadUri,
            ffi::G_CONVERT_ERROR_NOT_ABSOLUTE_PATH => Self::NotAbsolutePath,
            ffi::G_CONVERT_ERROR_NO_MEMORY => Self::NoMemory,
            ffi::G_CONVERT_ERROR_EMBEDDED_NUL => Self::EmbeddedNul,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for ConvertError {
    fn domain() -> Quark {
        unsafe { from_glib(ffi::g_convert_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        match code {
            ffi::G_CONVERT_ERROR_NO_CONVERSION => Some(Self::NoConversion),
            ffi::G_CONVERT_ERROR_ILLEGAL_SEQUENCE => Some(Self::IllegalSequence),
            ffi::G_CONVERT_ERROR_FAILED => Some(Self::Failed),
            ffi::G_CONVERT_ERROR_PARTIAL_INPUT => Some(Self::PartialInput),
            ffi::G_CONVERT_ERROR_BAD_URI => Some(Self::BadUri),
            ffi::G_CONVERT_ERROR_NOT_ABSOLUTE_PATH => Some(Self::NotAbsolutePath),
            ffi::G_CONVERT_ERROR_NO_MEMORY => Some(Self::NoMemory),
            ffi::G_CONVERT_ERROR_EMBEDDED_NUL => Some(Self::EmbeddedNul),
            _ => Some(Self::Failed),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GDateMonth")]
pub enum DateMonth {
    #[doc(alias = "G_DATE_BAD_MONTH")]
    BadMonth,
    #[doc(alias = "G_DATE_JANUARY")]
    January,
    #[doc(alias = "G_DATE_FEBRUARY")]
    February,
    #[doc(alias = "G_DATE_MARCH")]
    March,
    #[doc(alias = "G_DATE_APRIL")]
    April,
    #[doc(alias = "G_DATE_MAY")]
    May,
    #[doc(alias = "G_DATE_JUNE")]
    June,
    #[doc(alias = "G_DATE_JULY")]
    July,
    #[doc(alias = "G_DATE_AUGUST")]
    August,
    #[doc(alias = "G_DATE_SEPTEMBER")]
    September,
    #[doc(alias = "G_DATE_OCTOBER")]
    October,
    #[doc(alias = "G_DATE_NOVEMBER")]
    November,
    #[doc(alias = "G_DATE_DECEMBER")]
    December,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for DateMonth {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "DateMonth::{}",
            match *self {
                Self::BadMonth => "BadMonth",
                Self::January => "January",
                Self::February => "February",
                Self::March => "March",
                Self::April => "April",
                Self::May => "May",
                Self::June => "June",
                Self::July => "July",
                Self::August => "August",
                Self::September => "September",
                Self::October => "October",
                Self::November => "November",
                Self::December => "December",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for DateMonth {
    type GlibType = ffi::GDateMonth;

    fn into_glib(self) -> ffi::GDateMonth {
        match self {
            Self::BadMonth => ffi::G_DATE_BAD_MONTH,
            Self::January => ffi::G_DATE_JANUARY,
            Self::February => ffi::G_DATE_FEBRUARY,
            Self::March => ffi::G_DATE_MARCH,
            Self::April => ffi::G_DATE_APRIL,
            Self::May => ffi::G_DATE_MAY,
            Self::June => ffi::G_DATE_JUNE,
            Self::July => ffi::G_DATE_JULY,
            Self::August => ffi::G_DATE_AUGUST,
            Self::September => ffi::G_DATE_SEPTEMBER,
            Self::October => ffi::G_DATE_OCTOBER,
            Self::November => ffi::G_DATE_NOVEMBER,
            Self::December => ffi::G_DATE_DECEMBER,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GDateMonth> for DateMonth {
    unsafe fn from_glib(value: ffi::GDateMonth) -> Self {
        match value {
            ffi::G_DATE_BAD_MONTH => Self::BadMonth,
            ffi::G_DATE_JANUARY => Self::January,
            ffi::G_DATE_FEBRUARY => Self::February,
            ffi::G_DATE_MARCH => Self::March,
            ffi::G_DATE_APRIL => Self::April,
            ffi::G_DATE_MAY => Self::May,
            ffi::G_DATE_JUNE => Self::June,
            ffi::G_DATE_JULY => Self::July,
            ffi::G_DATE_AUGUST => Self::August,
            ffi::G_DATE_SEPTEMBER => Self::September,
            ffi::G_DATE_OCTOBER => Self::October,
            ffi::G_DATE_NOVEMBER => Self::November,
            ffi::G_DATE_DECEMBER => Self::December,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GDateWeekday")]
pub enum DateWeekday {
    #[doc(alias = "G_DATE_BAD_WEEKDAY")]
    BadWeekday,
    #[doc(alias = "G_DATE_MONDAY")]
    Monday,
    #[doc(alias = "G_DATE_TUESDAY")]
    Tuesday,
    #[doc(alias = "G_DATE_WEDNESDAY")]
    Wednesday,
    #[doc(alias = "G_DATE_THURSDAY")]
    Thursday,
    #[doc(alias = "G_DATE_FRIDAY")]
    Friday,
    #[doc(alias = "G_DATE_SATURDAY")]
    Saturday,
    #[doc(alias = "G_DATE_SUNDAY")]
    Sunday,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for DateWeekday {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "DateWeekday::{}",
            match *self {
                Self::BadWeekday => "BadWeekday",
                Self::Monday => "Monday",
                Self::Tuesday => "Tuesday",
                Self::Wednesday => "Wednesday",
                Self::Thursday => "Thursday",
                Self::Friday => "Friday",
                Self::Saturday => "Saturday",
                Self::Sunday => "Sunday",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for DateWeekday {
    type GlibType = ffi::GDateWeekday;

    fn into_glib(self) -> ffi::GDateWeekday {
        match self {
            Self::BadWeekday => ffi::G_DATE_BAD_WEEKDAY,
            Self::Monday => ffi::G_DATE_MONDAY,
            Self::Tuesday => ffi::G_DATE_TUESDAY,
            Self::Wednesday => ffi::G_DATE_WEDNESDAY,
            Self::Thursday => ffi::G_DATE_THURSDAY,
            Self::Friday => ffi::G_DATE_FRIDAY,
            Self::Saturday => ffi::G_DATE_SATURDAY,
            Self::Sunday => ffi::G_DATE_SUNDAY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GDateWeekday> for DateWeekday {
    unsafe fn from_glib(value: ffi::GDateWeekday) -> Self {
        match value {
            ffi::G_DATE_BAD_WEEKDAY => Self::BadWeekday,
            ffi::G_DATE_MONDAY => Self::Monday,
            ffi::G_DATE_TUESDAY => Self::Tuesday,
            ffi::G_DATE_WEDNESDAY => Self::Wednesday,
            ffi::G_DATE_THURSDAY => Self::Thursday,
            ffi::G_DATE_FRIDAY => Self::Friday,
            ffi::G_DATE_SATURDAY => Self::Saturday,
            ffi::G_DATE_SUNDAY => Self::Sunday,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GFileError")]
pub enum FileError {
    #[doc(alias = "G_FILE_ERROR_EXIST")]
    Exist,
    #[doc(alias = "G_FILE_ERROR_ISDIR")]
    Isdir,
    #[doc(alias = "G_FILE_ERROR_ACCES")]
    Acces,
    #[doc(alias = "G_FILE_ERROR_NAMETOOLONG")]
    Nametoolong,
    #[doc(alias = "G_FILE_ERROR_NOENT")]
    Noent,
    #[doc(alias = "G_FILE_ERROR_NOTDIR")]
    Notdir,
    #[doc(alias = "G_FILE_ERROR_NXIO")]
    Nxio,
    #[doc(alias = "G_FILE_ERROR_NODEV")]
    Nodev,
    #[doc(alias = "G_FILE_ERROR_ROFS")]
    Rofs,
    #[doc(alias = "G_FILE_ERROR_TXTBSY")]
    Txtbsy,
    #[doc(alias = "G_FILE_ERROR_FAULT")]
    Fault,
    #[doc(alias = "G_FILE_ERROR_LOOP")]
    Loop,
    #[doc(alias = "G_FILE_ERROR_NOSPC")]
    Nospc,
    #[doc(alias = "G_FILE_ERROR_NOMEM")]
    Nomem,
    #[doc(alias = "G_FILE_ERROR_MFILE")]
    Mfile,
    #[doc(alias = "G_FILE_ERROR_NFILE")]
    Nfile,
    #[doc(alias = "G_FILE_ERROR_BADF")]
    Badf,
    #[doc(alias = "G_FILE_ERROR_INVAL")]
    Inval,
    #[doc(alias = "G_FILE_ERROR_PIPE")]
    Pipe,
    #[doc(alias = "G_FILE_ERROR_AGAIN")]
    Again,
    #[doc(alias = "G_FILE_ERROR_INTR")]
    Intr,
    #[doc(alias = "G_FILE_ERROR_IO")]
    Io,
    #[doc(alias = "G_FILE_ERROR_PERM")]
    Perm,
    #[doc(alias = "G_FILE_ERROR_NOSYS")]
    Nosys,
    #[doc(alias = "G_FILE_ERROR_FAILED")]
    Failed,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FileError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FileError::{}",
            match *self {
                Self::Exist => "Exist",
                Self::Isdir => "Isdir",
                Self::Acces => "Acces",
                Self::Nametoolong => "Nametoolong",
                Self::Noent => "Noent",
                Self::Notdir => "Notdir",
                Self::Nxio => "Nxio",
                Self::Nodev => "Nodev",
                Self::Rofs => "Rofs",
                Self::Txtbsy => "Txtbsy",
                Self::Fault => "Fault",
                Self::Loop => "Loop",
                Self::Nospc => "Nospc",
                Self::Nomem => "Nomem",
                Self::Mfile => "Mfile",
                Self::Nfile => "Nfile",
                Self::Badf => "Badf",
                Self::Inval => "Inval",
                Self::Pipe => "Pipe",
                Self::Again => "Again",
                Self::Intr => "Intr",
                Self::Io => "Io",
                Self::Perm => "Perm",
                Self::Nosys => "Nosys",
                Self::Failed => "Failed",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FileError {
    type GlibType = ffi::GFileError;

    fn into_glib(self) -> ffi::GFileError {
        match self {
            Self::Exist => ffi::G_FILE_ERROR_EXIST,
            Self::Isdir => ffi::G_FILE_ERROR_ISDIR,
            Self::Acces => ffi::G_FILE_ERROR_ACCES,
            Self::Nametoolong => ffi::G_FILE_ERROR_NAMETOOLONG,
            Self::Noent => ffi::G_FILE_ERROR_NOENT,
            Self::Notdir => ffi::G_FILE_ERROR_NOTDIR,
            Self::Nxio => ffi::G_FILE_ERROR_NXIO,
            Self::Nodev => ffi::G_FILE_ERROR_NODEV,
            Self::Rofs => ffi::G_FILE_ERROR_ROFS,
            Self::Txtbsy => ffi::G_FILE_ERROR_TXTBSY,
            Self::Fault => ffi::G_FILE_ERROR_FAULT,
            Self::Loop => ffi::G_FILE_ERROR_LOOP,
            Self::Nospc => ffi::G_FILE_ERROR_NOSPC,
            Self::Nomem => ffi::G_FILE_ERROR_NOMEM,
            Self::Mfile => ffi::G_FILE_ERROR_MFILE,
            Self::Nfile => ffi::G_FILE_ERROR_NFILE,
            Self::Badf => ffi::G_FILE_ERROR_BADF,
            Self::Inval => ffi::G_FILE_ERROR_INVAL,
            Self::Pipe => ffi::G_FILE_ERROR_PIPE,
            Self::Again => ffi::G_FILE_ERROR_AGAIN,
            Self::Intr => ffi::G_FILE_ERROR_INTR,
            Self::Io => ffi::G_FILE_ERROR_IO,
            Self::Perm => ffi::G_FILE_ERROR_PERM,
            Self::Nosys => ffi::G_FILE_ERROR_NOSYS,
            Self::Failed => ffi::G_FILE_ERROR_FAILED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GFileError> for FileError {
    unsafe fn from_glib(value: ffi::GFileError) -> Self {
        match value {
            ffi::G_FILE_ERROR_EXIST => Self::Exist,
            ffi::G_FILE_ERROR_ISDIR => Self::Isdir,
            ffi::G_FILE_ERROR_ACCES => Self::Acces,
            ffi::G_FILE_ERROR_NAMETOOLONG => Self::Nametoolong,
            ffi::G_FILE_ERROR_NOENT => Self::Noent,
            ffi::G_FILE_ERROR_NOTDIR => Self::Notdir,
            ffi::G_FILE_ERROR_NXIO => Self::Nxio,
            ffi::G_FILE_ERROR_NODEV => Self::Nodev,
            ffi::G_FILE_ERROR_ROFS => Self::Rofs,
            ffi::G_FILE_ERROR_TXTBSY => Self::Txtbsy,
            ffi::G_FILE_ERROR_FAULT => Self::Fault,
            ffi::G_FILE_ERROR_LOOP => Self::Loop,
            ffi::G_FILE_ERROR_NOSPC => Self::Nospc,
            ffi::G_FILE_ERROR_NOMEM => Self::Nomem,
            ffi::G_FILE_ERROR_MFILE => Self::Mfile,
            ffi::G_FILE_ERROR_NFILE => Self::Nfile,
            ffi::G_FILE_ERROR_BADF => Self::Badf,
            ffi::G_FILE_ERROR_INVAL => Self::Inval,
            ffi::G_FILE_ERROR_PIPE => Self::Pipe,
            ffi::G_FILE_ERROR_AGAIN => Self::Again,
            ffi::G_FILE_ERROR_INTR => Self::Intr,
            ffi::G_FILE_ERROR_IO => Self::Io,
            ffi::G_FILE_ERROR_PERM => Self::Perm,
            ffi::G_FILE_ERROR_NOSYS => Self::Nosys,
            ffi::G_FILE_ERROR_FAILED => Self::Failed,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for FileError {
    fn domain() -> Quark {
        unsafe { from_glib(ffi::g_file_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        match code {
            ffi::G_FILE_ERROR_EXIST => Some(Self::Exist),
            ffi::G_FILE_ERROR_ISDIR => Some(Self::Isdir),
            ffi::G_FILE_ERROR_ACCES => Some(Self::Acces),
            ffi::G_FILE_ERROR_NAMETOOLONG => Some(Self::Nametoolong),
            ffi::G_FILE_ERROR_NOENT => Some(Self::Noent),
            ffi::G_FILE_ERROR_NOTDIR => Some(Self::Notdir),
            ffi::G_FILE_ERROR_NXIO => Some(Self::Nxio),
            ffi::G_FILE_ERROR_NODEV => Some(Self::Nodev),
            ffi::G_FILE_ERROR_ROFS => Some(Self::Rofs),
            ffi::G_FILE_ERROR_TXTBSY => Some(Self::Txtbsy),
            ffi::G_FILE_ERROR_FAULT => Some(Self::Fault),
            ffi::G_FILE_ERROR_LOOP => Some(Self::Loop),
            ffi::G_FILE_ERROR_NOSPC => Some(Self::Nospc),
            ffi::G_FILE_ERROR_NOMEM => Some(Self::Nomem),
            ffi::G_FILE_ERROR_MFILE => Some(Self::Mfile),
            ffi::G_FILE_ERROR_NFILE => Some(Self::Nfile),
            ffi::G_FILE_ERROR_BADF => Some(Self::Badf),
            ffi::G_FILE_ERROR_INVAL => Some(Self::Inval),
            ffi::G_FILE_ERROR_PIPE => Some(Self::Pipe),
            ffi::G_FILE_ERROR_AGAIN => Some(Self::Again),
            ffi::G_FILE_ERROR_INTR => Some(Self::Intr),
            ffi::G_FILE_ERROR_IO => Some(Self::Io),
            ffi::G_FILE_ERROR_PERM => Some(Self::Perm),
            ffi::G_FILE_ERROR_NOSYS => Some(Self::Nosys),
            ffi::G_FILE_ERROR_FAILED => Some(Self::Failed),
            _ => Some(Self::Failed),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GKeyFileError")]
pub enum KeyFileError {
    #[doc(alias = "G_KEY_FILE_ERROR_UNKNOWN_ENCODING")]
    UnknownEncoding,
    #[doc(alias = "G_KEY_FILE_ERROR_PARSE")]
    Parse,
    #[doc(alias = "G_KEY_FILE_ERROR_NOT_FOUND")]
    NotFound,
    #[doc(alias = "G_KEY_FILE_ERROR_KEY_NOT_FOUND")]
    KeyNotFound,
    #[doc(alias = "G_KEY_FILE_ERROR_GROUP_NOT_FOUND")]
    GroupNotFound,
    #[doc(alias = "G_KEY_FILE_ERROR_INVALID_VALUE")]
    InvalidValue,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for KeyFileError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "KeyFileError::{}",
            match *self {
                Self::UnknownEncoding => "UnknownEncoding",
                Self::Parse => "Parse",
                Self::NotFound => "NotFound",
                Self::KeyNotFound => "KeyNotFound",
                Self::GroupNotFound => "GroupNotFound",
                Self::InvalidValue => "InvalidValue",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for KeyFileError {
    type GlibType = ffi::GKeyFileError;

    fn into_glib(self) -> ffi::GKeyFileError {
        match self {
            Self::UnknownEncoding => ffi::G_KEY_FILE_ERROR_UNKNOWN_ENCODING,
            Self::Parse => ffi::G_KEY_FILE_ERROR_PARSE,
            Self::NotFound => ffi::G_KEY_FILE_ERROR_NOT_FOUND,
            Self::KeyNotFound => ffi::G_KEY_FILE_ERROR_KEY_NOT_FOUND,
            Self::GroupNotFound => ffi::G_KEY_FILE_ERROR_GROUP_NOT_FOUND,
            Self::InvalidValue => ffi::G_KEY_FILE_ERROR_INVALID_VALUE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GKeyFileError> for KeyFileError {
    unsafe fn from_glib(value: ffi::GKeyFileError) -> Self {
        match value {
            ffi::G_KEY_FILE_ERROR_UNKNOWN_ENCODING => Self::UnknownEncoding,
            ffi::G_KEY_FILE_ERROR_PARSE => Self::Parse,
            ffi::G_KEY_FILE_ERROR_NOT_FOUND => Self::NotFound,
            ffi::G_KEY_FILE_ERROR_KEY_NOT_FOUND => Self::KeyNotFound,
            ffi::G_KEY_FILE_ERROR_GROUP_NOT_FOUND => Self::GroupNotFound,
            ffi::G_KEY_FILE_ERROR_INVALID_VALUE => Self::InvalidValue,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for KeyFileError {
    fn domain() -> Quark {
        unsafe { from_glib(ffi::g_key_file_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        match code {
            ffi::G_KEY_FILE_ERROR_UNKNOWN_ENCODING => Some(Self::UnknownEncoding),
            ffi::G_KEY_FILE_ERROR_PARSE => Some(Self::Parse),
            ffi::G_KEY_FILE_ERROR_NOT_FOUND => Some(Self::NotFound),
            ffi::G_KEY_FILE_ERROR_KEY_NOT_FOUND => Some(Self::KeyNotFound),
            ffi::G_KEY_FILE_ERROR_GROUP_NOT_FOUND => Some(Self::GroupNotFound),
            ffi::G_KEY_FILE_ERROR_INVALID_VALUE => Some(Self::InvalidValue),
            value => Some(Self::__Unknown(value)),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GLogWriterOutput")]
pub enum LogWriterOutput {
    #[doc(alias = "G_LOG_WRITER_HANDLED")]
    Handled,
    #[doc(alias = "G_LOG_WRITER_UNHANDLED")]
    Unhandled,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for LogWriterOutput {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "LogWriterOutput::{}",
            match *self {
                Self::Handled => "Handled",
                Self::Unhandled => "Unhandled",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for LogWriterOutput {
    type GlibType = ffi::GLogWriterOutput;

    fn into_glib(self) -> ffi::GLogWriterOutput {
        match self {
            Self::Handled => ffi::G_LOG_WRITER_HANDLED,
            Self::Unhandled => ffi::G_LOG_WRITER_UNHANDLED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GLogWriterOutput> for LogWriterOutput {
    unsafe fn from_glib(value: ffi::GLogWriterOutput) -> Self {
        match value {
            ffi::G_LOG_WRITER_HANDLED => Self::Handled,
            ffi::G_LOG_WRITER_UNHANDLED => Self::Unhandled,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GMarkupError")]
pub enum MarkupError {
    #[doc(alias = "G_MARKUP_ERROR_BAD_UTF8")]
    BadUtf8,
    #[doc(alias = "G_MARKUP_ERROR_EMPTY")]
    Empty,
    #[doc(alias = "G_MARKUP_ERROR_PARSE")]
    Parse,
    #[doc(alias = "G_MARKUP_ERROR_UNKNOWN_ELEMENT")]
    UnknownElement,
    #[doc(alias = "G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE")]
    UnknownAttribute,
    #[doc(alias = "G_MARKUP_ERROR_INVALID_CONTENT")]
    InvalidContent,
    #[doc(alias = "G_MARKUP_ERROR_MISSING_ATTRIBUTE")]
    MissingAttribute,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for MarkupError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "MarkupError::{}",
            match *self {
                Self::BadUtf8 => "BadUtf8",
                Self::Empty => "Empty",
                Self::Parse => "Parse",
                Self::UnknownElement => "UnknownElement",
                Self::UnknownAttribute => "UnknownAttribute",
                Self::InvalidContent => "InvalidContent",
                Self::MissingAttribute => "MissingAttribute",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for MarkupError {
    type GlibType = ffi::GMarkupError;

    fn into_glib(self) -> ffi::GMarkupError {
        match self {
            Self::BadUtf8 => ffi::G_MARKUP_ERROR_BAD_UTF8,
            Self::Empty => ffi::G_MARKUP_ERROR_EMPTY,
            Self::Parse => ffi::G_MARKUP_ERROR_PARSE,
            Self::UnknownElement => ffi::G_MARKUP_ERROR_UNKNOWN_ELEMENT,
            Self::UnknownAttribute => ffi::G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE,
            Self::InvalidContent => ffi::G_MARKUP_ERROR_INVALID_CONTENT,
            Self::MissingAttribute => ffi::G_MARKUP_ERROR_MISSING_ATTRIBUTE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GMarkupError> for MarkupError {
    unsafe fn from_glib(value: ffi::GMarkupError) -> Self {
        match value {
            ffi::G_MARKUP_ERROR_BAD_UTF8 => Self::BadUtf8,
            ffi::G_MARKUP_ERROR_EMPTY => Self::Empty,
            ffi::G_MARKUP_ERROR_PARSE => Self::Parse,
            ffi::G_MARKUP_ERROR_UNKNOWN_ELEMENT => Self::UnknownElement,
            ffi::G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE => Self::UnknownAttribute,
            ffi::G_MARKUP_ERROR_INVALID_CONTENT => Self::InvalidContent,
            ffi::G_MARKUP_ERROR_MISSING_ATTRIBUTE => Self::MissingAttribute,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for MarkupError {
    fn domain() -> Quark {
        unsafe { from_glib(ffi::g_markup_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        match code {
            ffi::G_MARKUP_ERROR_BAD_UTF8 => Some(Self::BadUtf8),
            ffi::G_MARKUP_ERROR_EMPTY => Some(Self::Empty),
            ffi::G_MARKUP_ERROR_PARSE => Some(Self::Parse),
            ffi::G_MARKUP_ERROR_UNKNOWN_ELEMENT => Some(Self::UnknownElement),
            ffi::G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE => Some(Self::UnknownAttribute),
            ffi::G_MARKUP_ERROR_INVALID_CONTENT => Some(Self::InvalidContent),
            ffi::G_MARKUP_ERROR_MISSING_ATTRIBUTE => Some(Self::MissingAttribute),
            value => Some(Self::__Unknown(value)),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GOptionArg")]
pub enum OptionArg {
    #[doc(alias = "G_OPTION_ARG_NONE")]
    None,
    #[doc(alias = "G_OPTION_ARG_STRING")]
    String,
    #[doc(alias = "G_OPTION_ARG_INT")]
    Int,
    #[doc(alias = "G_OPTION_ARG_CALLBACK")]
    Callback,
    #[doc(alias = "G_OPTION_ARG_FILENAME")]
    Filename,
    #[doc(alias = "G_OPTION_ARG_STRING_ARRAY")]
    StringArray,
    #[doc(alias = "G_OPTION_ARG_FILENAME_ARRAY")]
    FilenameArray,
    #[doc(alias = "G_OPTION_ARG_DOUBLE")]
    Double,
    #[doc(alias = "G_OPTION_ARG_INT64")]
    Int64,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for OptionArg {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "OptionArg::{}",
            match *self {
                Self::None => "None",
                Self::String => "String",
                Self::Int => "Int",
                Self::Callback => "Callback",
                Self::Filename => "Filename",
                Self::StringArray => "StringArray",
                Self::FilenameArray => "FilenameArray",
                Self::Double => "Double",
                Self::Int64 => "Int64",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for OptionArg {
    type GlibType = ffi::GOptionArg;

    fn into_glib(self) -> ffi::GOptionArg {
        match self {
            Self::None => ffi::G_OPTION_ARG_NONE,
            Self::String => ffi::G_OPTION_ARG_STRING,
            Self::Int => ffi::G_OPTION_ARG_INT,
            Self::Callback => ffi::G_OPTION_ARG_CALLBACK,
            Self::Filename => ffi::G_OPTION_ARG_FILENAME,
            Self::StringArray => ffi::G_OPTION_ARG_STRING_ARRAY,
            Self::FilenameArray => ffi::G_OPTION_ARG_FILENAME_ARRAY,
            Self::Double => ffi::G_OPTION_ARG_DOUBLE,
            Self::Int64 => ffi::G_OPTION_ARG_INT64,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GOptionArg> for OptionArg {
    unsafe fn from_glib(value: ffi::GOptionArg) -> Self {
        match value {
            ffi::G_OPTION_ARG_NONE => Self::None,
            ffi::G_OPTION_ARG_STRING => Self::String,
            ffi::G_OPTION_ARG_INT => Self::Int,
            ffi::G_OPTION_ARG_CALLBACK => Self::Callback,
            ffi::G_OPTION_ARG_FILENAME => Self::Filename,
            ffi::G_OPTION_ARG_STRING_ARRAY => Self::StringArray,
            ffi::G_OPTION_ARG_FILENAME_ARRAY => Self::FilenameArray,
            ffi::G_OPTION_ARG_DOUBLE => Self::Double,
            ffi::G_OPTION_ARG_INT64 => Self::Int64,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GSeekType")]
pub enum SeekType {
    #[doc(alias = "G_SEEK_CUR")]
    Cur,
    #[doc(alias = "G_SEEK_SET")]
    Set,
    #[doc(alias = "G_SEEK_END")]
    End,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SeekType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SeekType::{}",
            match *self {
                Self::Cur => "Cur",
                Self::Set => "Set",
                Self::End => "End",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SeekType {
    type GlibType = ffi::GSeekType;

    fn into_glib(self) -> ffi::GSeekType {
        match self {
            Self::Cur => ffi::G_SEEK_CUR,
            Self::Set => ffi::G_SEEK_SET,
            Self::End => ffi::G_SEEK_END,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GSeekType> for SeekType {
    unsafe fn from_glib(value: ffi::GSeekType) -> Self {
        match value {
            ffi::G_SEEK_CUR => Self::Cur,
            ffi::G_SEEK_SET => Self::Set,
            ffi::G_SEEK_END => Self::End,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GTimeType")]
pub enum TimeType {
    #[doc(alias = "G_TIME_TYPE_STANDARD")]
    Standard,
    #[doc(alias = "G_TIME_TYPE_DAYLIGHT")]
    Daylight,
    #[doc(alias = "G_TIME_TYPE_UNIVERSAL")]
    Universal,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TimeType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TimeType::{}",
            match *self {
                Self::Standard => "Standard",
                Self::Daylight => "Daylight",
                Self::Universal => "Universal",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TimeType {
    type GlibType = ffi::GTimeType;

    fn into_glib(self) -> ffi::GTimeType {
        match self {
            Self::Standard => ffi::G_TIME_TYPE_STANDARD,
            Self::Daylight => ffi::G_TIME_TYPE_DAYLIGHT,
            Self::Universal => ffi::G_TIME_TYPE_UNIVERSAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GTimeType> for TimeType {
    unsafe fn from_glib(value: ffi::GTimeType) -> Self {
        match value {
            ffi::G_TIME_TYPE_STANDARD => Self::Standard,
            ffi::G_TIME_TYPE_DAYLIGHT => Self::Daylight,
            ffi::G_TIME_TYPE_UNIVERSAL => Self::Universal,
            value => Self::__Unknown(value),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GUnicodeScript")]
pub enum UnicodeScript {
    #[doc(alias = "G_UNICODE_SCRIPT_INVALID_CODE")]
    InvalidCode,
    #[doc(alias = "G_UNICODE_SCRIPT_COMMON")]
    Common,
    #[doc(alias = "G_UNICODE_SCRIPT_INHERITED")]
    Inherited,
    #[doc(alias = "G_UNICODE_SCRIPT_ARABIC")]
    Arabic,
    #[doc(alias = "G_UNICODE_SCRIPT_ARMENIAN")]
    Armenian,
    #[doc(alias = "G_UNICODE_SCRIPT_BENGALI")]
    Bengali,
    #[doc(alias = "G_UNICODE_SCRIPT_BOPOMOFO")]
    Bopomofo,
    #[doc(alias = "G_UNICODE_SCRIPT_CHEROKEE")]
    Cherokee,
    #[doc(alias = "G_UNICODE_SCRIPT_COPTIC")]
    Coptic,
    #[doc(alias = "G_UNICODE_SCRIPT_CYRILLIC")]
    Cyrillic,
    #[doc(alias = "G_UNICODE_SCRIPT_DESERET")]
    Deseret,
    #[doc(alias = "G_UNICODE_SCRIPT_DEVANAGARI")]
    Devanagari,
    #[doc(alias = "G_UNICODE_SCRIPT_ETHIOPIC")]
    Ethiopic,
    #[doc(alias = "G_UNICODE_SCRIPT_GEORGIAN")]
    Georgian,
    #[doc(alias = "G_UNICODE_SCRIPT_GOTHIC")]
    Gothic,
    #[doc(alias = "G_UNICODE_SCRIPT_GREEK")]
    Greek,
    #[doc(alias = "G_UNICODE_SCRIPT_GUJARATI")]
    Gujarati,
    #[doc(alias = "G_UNICODE_SCRIPT_GURMUKHI")]
    Gurmukhi,
    #[doc(alias = "G_UNICODE_SCRIPT_HAN")]
    Han,
    #[doc(alias = "G_UNICODE_SCRIPT_HANGUL")]
    Hangul,
    #[doc(alias = "G_UNICODE_SCRIPT_HEBREW")]
    Hebrew,
    #[doc(alias = "G_UNICODE_SCRIPT_HIRAGANA")]
    Hiragana,
    #[doc(alias = "G_UNICODE_SCRIPT_KANNADA")]
    Kannada,
    #[doc(alias = "G_UNICODE_SCRIPT_KATAKANA")]
    Katakana,
    #[doc(alias = "G_UNICODE_SCRIPT_KHMER")]
    Khmer,
    #[doc(alias = "G_UNICODE_SCRIPT_LAO")]
    Lao,
    #[doc(alias = "G_UNICODE_SCRIPT_LATIN")]
    Latin,
    #[doc(alias = "G_UNICODE_SCRIPT_MALAYALAM")]
    Malayalam,
    #[doc(alias = "G_UNICODE_SCRIPT_MONGOLIAN")]
    Mongolian,
    #[doc(alias = "G_UNICODE_SCRIPT_MYANMAR")]
    Myanmar,
    #[doc(alias = "G_UNICODE_SCRIPT_OGHAM")]
    Ogham,
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_ITALIC")]
    OldItalic,
    #[doc(alias = "G_UNICODE_SCRIPT_ORIYA")]
    Oriya,
    #[doc(alias = "G_UNICODE_SCRIPT_RUNIC")]
    Runic,
    #[doc(alias = "G_UNICODE_SCRIPT_SINHALA")]
    Sinhala,
    #[doc(alias = "G_UNICODE_SCRIPT_SYRIAC")]
    Syriac,
    #[doc(alias = "G_UNICODE_SCRIPT_TAMIL")]
    Tamil,
    #[doc(alias = "G_UNICODE_SCRIPT_TELUGU")]
    Telugu,
    #[doc(alias = "G_UNICODE_SCRIPT_THAANA")]
    Thaana,
    #[doc(alias = "G_UNICODE_SCRIPT_THAI")]
    Thai,
    #[doc(alias = "G_UNICODE_SCRIPT_TIBETAN")]
    Tibetan,
    #[doc(alias = "G_UNICODE_SCRIPT_CANADIAN_ABORIGINAL")]
    CanadianAboriginal,
    #[doc(alias = "G_UNICODE_SCRIPT_YI")]
    Yi,
    #[doc(alias = "G_UNICODE_SCRIPT_TAGALOG")]
    Tagalog,
    #[doc(alias = "G_UNICODE_SCRIPT_HANUNOO")]
    Hanunoo,
    #[doc(alias = "G_UNICODE_SCRIPT_BUHID")]
    Buhid,
    #[doc(alias = "G_UNICODE_SCRIPT_TAGBANWA")]
    Tagbanwa,
    #[doc(alias = "G_UNICODE_SCRIPT_BRAILLE")]
    Braille,
    #[doc(alias = "G_UNICODE_SCRIPT_CYPRIOT")]
    Cypriot,
    #[doc(alias = "G_UNICODE_SCRIPT_LIMBU")]
    Limbu,
    #[doc(alias = "G_UNICODE_SCRIPT_OSMANYA")]
    Osmanya,
    #[doc(alias = "G_UNICODE_SCRIPT_SHAVIAN")]
    Shavian,
    #[doc(alias = "G_UNICODE_SCRIPT_LINEAR_B")]
    LinearB,
    #[doc(alias = "G_UNICODE_SCRIPT_TAI_LE")]
    TaiLe,
    #[doc(alias = "G_UNICODE_SCRIPT_UGARITIC")]
    Ugaritic,
    #[doc(alias = "G_UNICODE_SCRIPT_NEW_TAI_LUE")]
    NewTaiLue,
    #[doc(alias = "G_UNICODE_SCRIPT_BUGINESE")]
    Buginese,
    #[doc(alias = "G_UNICODE_SCRIPT_GLAGOLITIC")]
    Glagolitic,
    #[doc(alias = "G_UNICODE_SCRIPT_TIFINAGH")]
    Tifinagh,
    #[doc(alias = "G_UNICODE_SCRIPT_SYLOTI_NAGRI")]
    SylotiNagri,
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_PERSIAN")]
    OldPersian,
    #[doc(alias = "G_UNICODE_SCRIPT_KHAROSHTHI")]
    Kharoshthi,
    #[doc(alias = "G_UNICODE_SCRIPT_UNKNOWN")]
    Unknown,
    #[doc(alias = "G_UNICODE_SCRIPT_BALINESE")]
    Balinese,
    #[doc(alias = "G_UNICODE_SCRIPT_CUNEIFORM")]
    Cuneiform,
    #[doc(alias = "G_UNICODE_SCRIPT_PHOENICIAN")]
    Phoenician,
    #[doc(alias = "G_UNICODE_SCRIPT_PHAGS_PA")]
    PhagsPa,
    #[doc(alias = "G_UNICODE_SCRIPT_NKO")]
    Nko,
    #[doc(alias = "G_UNICODE_SCRIPT_KAYAH_LI")]
    KayahLi,
    #[doc(alias = "G_UNICODE_SCRIPT_LEPCHA")]
    Lepcha,
    #[doc(alias = "G_UNICODE_SCRIPT_REJANG")]
    Rejang,
    #[doc(alias = "G_UNICODE_SCRIPT_SUNDANESE")]
    Sundanese,
    #[doc(alias = "G_UNICODE_SCRIPT_SAURASHTRA")]
    Saurashtra,
    #[doc(alias = "G_UNICODE_SCRIPT_CHAM")]
    Cham,
    #[doc(alias = "G_UNICODE_SCRIPT_OL_CHIKI")]
    OlChiki,
    #[doc(alias = "G_UNICODE_SCRIPT_VAI")]
    Vai,
    #[doc(alias = "G_UNICODE_SCRIPT_CARIAN")]
    Carian,
    #[doc(alias = "G_UNICODE_SCRIPT_LYCIAN")]
    Lycian,
    #[doc(alias = "G_UNICODE_SCRIPT_LYDIAN")]
    Lydian,
    #[doc(alias = "G_UNICODE_SCRIPT_AVESTAN")]
    Avestan,
    #[doc(alias = "G_UNICODE_SCRIPT_BAMUM")]
    Bamum,
    #[doc(alias = "G_UNICODE_SCRIPT_EGYPTIAN_HIEROGLYPHS")]
    EgyptianHieroglyphs,
    #[doc(alias = "G_UNICODE_SCRIPT_IMPERIAL_ARAMAIC")]
    ImperialAramaic,
    #[doc(alias = "G_UNICODE_SCRIPT_INSCRIPTIONAL_PAHLAVI")]
    InscriptionalPahlavi,
    #[doc(alias = "G_UNICODE_SCRIPT_INSCRIPTIONAL_PARTHIAN")]
    InscriptionalParthian,
    #[doc(alias = "G_UNICODE_SCRIPT_JAVANESE")]
    Javanese,
    #[doc(alias = "G_UNICODE_SCRIPT_KAITHI")]
    Kaithi,
    #[doc(alias = "G_UNICODE_SCRIPT_LISU")]
    Lisu,
    #[doc(alias = "G_UNICODE_SCRIPT_MEETEI_MAYEK")]
    MeeteiMayek,
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_SOUTH_ARABIAN")]
    OldSouthArabian,
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_TURKIC")]
    OldTurkic,
    #[doc(alias = "G_UNICODE_SCRIPT_SAMARITAN")]
    Samaritan,
    #[doc(alias = "G_UNICODE_SCRIPT_TAI_THAM")]
    TaiTham,
    #[doc(alias = "G_UNICODE_SCRIPT_TAI_VIET")]
    TaiViet,
    #[doc(alias = "G_UNICODE_SCRIPT_BATAK")]
    Batak,
    #[doc(alias = "G_UNICODE_SCRIPT_BRAHMI")]
    Brahmi,
    #[doc(alias = "G_UNICODE_SCRIPT_MANDAIC")]
    Mandaic,
    #[doc(alias = "G_UNICODE_SCRIPT_CHAKMA")]
    Chakma,
    #[doc(alias = "G_UNICODE_SCRIPT_MEROITIC_CURSIVE")]
    MeroiticCursive,
    #[doc(alias = "G_UNICODE_SCRIPT_MEROITIC_HIEROGLYPHS")]
    MeroiticHieroglyphs,
    #[doc(alias = "G_UNICODE_SCRIPT_MIAO")]
    Miao,
    #[doc(alias = "G_UNICODE_SCRIPT_SHARADA")]
    Sharada,
    #[doc(alias = "G_UNICODE_SCRIPT_SORA_SOMPENG")]
    SoraSompeng,
    #[doc(alias = "G_UNICODE_SCRIPT_TAKRI")]
    Takri,
    #[doc(alias = "G_UNICODE_SCRIPT_BASSA_VAH")]
    BassaVah,
    #[doc(alias = "G_UNICODE_SCRIPT_CAUCASIAN_ALBANIAN")]
    CaucasianAlbanian,
    #[doc(alias = "G_UNICODE_SCRIPT_DUPLOYAN")]
    Duployan,
    #[doc(alias = "G_UNICODE_SCRIPT_ELBASAN")]
    Elbasan,
    #[doc(alias = "G_UNICODE_SCRIPT_GRANTHA")]
    Grantha,
    #[doc(alias = "G_UNICODE_SCRIPT_KHOJKI")]
    Khojki,
    #[doc(alias = "G_UNICODE_SCRIPT_KHUDAWADI")]
    Khudawadi,
    #[doc(alias = "G_UNICODE_SCRIPT_LINEAR_A")]
    LinearA,
    #[doc(alias = "G_UNICODE_SCRIPT_MAHAJANI")]
    Mahajani,
    #[doc(alias = "G_UNICODE_SCRIPT_MANICHAEAN")]
    Manichaean,
    #[doc(alias = "G_UNICODE_SCRIPT_MENDE_KIKAKUI")]
    MendeKikakui,
    #[doc(alias = "G_UNICODE_SCRIPT_MODI")]
    Modi,
    #[doc(alias = "G_UNICODE_SCRIPT_MRO")]
    Mro,
    #[doc(alias = "G_UNICODE_SCRIPT_NABATAEAN")]
    Nabataean,
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_NORTH_ARABIAN")]
    OldNorthArabian,
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_PERMIC")]
    OldPermic,
    #[doc(alias = "G_UNICODE_SCRIPT_PAHAWH_HMONG")]
    PahawhHmong,
    #[doc(alias = "G_UNICODE_SCRIPT_PALMYRENE")]
    Palmyrene,
    #[doc(alias = "G_UNICODE_SCRIPT_PAU_CIN_HAU")]
    PauCinHau,
    #[doc(alias = "G_UNICODE_SCRIPT_PSALTER_PAHLAVI")]
    PsalterPahlavi,
    #[doc(alias = "G_UNICODE_SCRIPT_SIDDHAM")]
    Siddham,
    #[doc(alias = "G_UNICODE_SCRIPT_TIRHUTA")]
    Tirhuta,
    #[doc(alias = "G_UNICODE_SCRIPT_WARANG_CITI")]
    WarangCiti,
    #[doc(alias = "G_UNICODE_SCRIPT_AHOM")]
    Ahom,
    #[doc(alias = "G_UNICODE_SCRIPT_ANATOLIAN_HIEROGLYPHS")]
    AnatolianHieroglyphs,
    #[doc(alias = "G_UNICODE_SCRIPT_HATRAN")]
    Hatran,
    #[doc(alias = "G_UNICODE_SCRIPT_MULTANI")]
    Multani,
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_HUNGARIAN")]
    OldHungarian,
    #[doc(alias = "G_UNICODE_SCRIPT_SIGNWRITING")]
    Signwriting,
    #[doc(alias = "G_UNICODE_SCRIPT_ADLAM")]
    Adlam,
    #[doc(alias = "G_UNICODE_SCRIPT_BHAIKSUKI")]
    Bhaiksuki,
    #[doc(alias = "G_UNICODE_SCRIPT_MARCHEN")]
    Marchen,
    #[doc(alias = "G_UNICODE_SCRIPT_NEWA")]
    Newa,
    #[doc(alias = "G_UNICODE_SCRIPT_OSAGE")]
    Osage,
    #[doc(alias = "G_UNICODE_SCRIPT_TANGUT")]
    Tangut,
    #[doc(alias = "G_UNICODE_SCRIPT_MASARAM_GONDI")]
    MasaramGondi,
    #[doc(alias = "G_UNICODE_SCRIPT_NUSHU")]
    Nushu,
    #[doc(alias = "G_UNICODE_SCRIPT_SOYOMBO")]
    Soyombo,
    #[doc(alias = "G_UNICODE_SCRIPT_ZANABAZAR_SQUARE")]
    ZanabazarSquare,
    #[doc(alias = "G_UNICODE_SCRIPT_DOGRA")]
    Dogra,
    #[doc(alias = "G_UNICODE_SCRIPT_GUNJALA_GONDI")]
    GunjalaGondi,
    #[doc(alias = "G_UNICODE_SCRIPT_HANIFI_ROHINGYA")]
    HanifiRohingya,
    #[doc(alias = "G_UNICODE_SCRIPT_MAKASAR")]
    Makasar,
    #[doc(alias = "G_UNICODE_SCRIPT_MEDEFAIDRIN")]
    Medefaidrin,
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_SOGDIAN")]
    OldSogdian,
    #[doc(alias = "G_UNICODE_SCRIPT_SOGDIAN")]
    Sogdian,
    #[doc(alias = "G_UNICODE_SCRIPT_ELYMAIC")]
    Elymaic,
    #[doc(alias = "G_UNICODE_SCRIPT_NANDINAGARI")]
    Nandinagari,
    #[doc(alias = "G_UNICODE_SCRIPT_NYIAKENG_PUACHUE_HMONG")]
    NyiakengPuachueHmong,
    #[doc(alias = "G_UNICODE_SCRIPT_WANCHO")]
    Wancho,
    #[doc(alias = "G_UNICODE_SCRIPT_CHORASMIAN")]
    Chorasmian,
    #[doc(alias = "G_UNICODE_SCRIPT_DIVES_AKURU")]
    DivesAkuru,
    #[doc(alias = "G_UNICODE_SCRIPT_KHITAN_SMALL_SCRIPT")]
    KhitanSmallScript,
    #[doc(alias = "G_UNICODE_SCRIPT_YEZIDI")]
    Yezidi,
    #[cfg(any(feature = "v2_72", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_72")))]
    #[doc(alias = "G_UNICODE_SCRIPT_CYPRO_MINOAN")]
    CyproMinoan,
    #[cfg(any(feature = "v2_72", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_72")))]
    #[doc(alias = "G_UNICODE_SCRIPT_OLD_UYGHUR")]
    OldUyghur,
    #[cfg(any(feature = "v2_72", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_72")))]
    #[doc(alias = "G_UNICODE_SCRIPT_TANGSA")]
    Tangsa,
    #[cfg(any(feature = "v2_72", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_72")))]
    #[doc(alias = "G_UNICODE_SCRIPT_TOTO")]
    Toto,
    #[cfg(any(feature = "v2_72", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_72")))]
    #[doc(alias = "G_UNICODE_SCRIPT_VITHKUQI")]
    Vithkuqi,
    #[cfg(any(feature = "v2_72", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_72")))]
    #[doc(alias = "G_UNICODE_SCRIPT_MATH")]
    Math,
    #[cfg(any(feature = "v2_74", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_74")))]
    #[doc(alias = "G_UNICODE_SCRIPT_KAWI")]
    Kawi,
    #[cfg(any(feature = "v2_74", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_74")))]
    #[doc(alias = "G_UNICODE_SCRIPT_NAG_MUNDARI")]
    NagMundari,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for UnicodeScript {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "UnicodeScript::{}",
            match *self {
                Self::InvalidCode => "InvalidCode",
                Self::Common => "Common",
                Self::Inherited => "Inherited",
                Self::Arabic => "Arabic",
                Self::Armenian => "Armenian",
                Self::Bengali => "Bengali",
                Self::Bopomofo => "Bopomofo",
                Self::Cherokee => "Cherokee",
                Self::Coptic => "Coptic",
                Self::Cyrillic => "Cyrillic",
                Self::Deseret => "Deseret",
                Self::Devanagari => "Devanagari",
                Self::Ethiopic => "Ethiopic",
                Self::Georgian => "Georgian",
                Self::Gothic => "Gothic",
                Self::Greek => "Greek",
                Self::Gujarati => "Gujarati",
                Self::Gurmukhi => "Gurmukhi",
                Self::Han => "Han",
                Self::Hangul => "Hangul",
                Self::Hebrew => "Hebrew",
                Self::Hiragana => "Hiragana",
                Self::Kannada => "Kannada",
                Self::Katakana => "Katakana",
                Self::Khmer => "Khmer",
                Self::Lao => "Lao",
                Self::Latin => "Latin",
                Self::Malayalam => "Malayalam",
                Self::Mongolian => "Mongolian",
                Self::Myanmar => "Myanmar",
                Self::Ogham => "Ogham",
                Self::OldItalic => "OldItalic",
                Self::Oriya => "Oriya",
                Self::Runic => "Runic",
                Self::Sinhala => "Sinhala",
                Self::Syriac => "Syriac",
                Self::Tamil => "Tamil",
                Self::Telugu => "Telugu",
                Self::Thaana => "Thaana",
                Self::Thai => "Thai",
                Self::Tibetan => "Tibetan",
                Self::CanadianAboriginal => "CanadianAboriginal",
                Self::Yi => "Yi",
                Self::Tagalog => "Tagalog",
                Self::Hanunoo => "Hanunoo",
                Self::Buhid => "Buhid",
                Self::Tagbanwa => "Tagbanwa",
                Self::Braille => "Braille",
                Self::Cypriot => "Cypriot",
                Self::Limbu => "Limbu",
                Self::Osmanya => "Osmanya",
                Self::Shavian => "Shavian",
                Self::LinearB => "LinearB",
                Self::TaiLe => "TaiLe",
                Self::Ugaritic => "Ugaritic",
                Self::NewTaiLue => "NewTaiLue",
                Self::Buginese => "Buginese",
                Self::Glagolitic => "Glagolitic",
                Self::Tifinagh => "Tifinagh",
                Self::SylotiNagri => "SylotiNagri",
                Self::OldPersian => "OldPersian",
                Self::Kharoshthi => "Kharoshthi",
                Self::Unknown => "Unknown",
                Self::Balinese => "Balinese",
                Self::Cuneiform => "Cuneiform",
                Self::Phoenician => "Phoenician",
                Self::PhagsPa => "PhagsPa",
                Self::Nko => "Nko",
                Self::KayahLi => "KayahLi",
                Self::Lepcha => "Lepcha",
                Self::Rejang => "Rejang",
                Self::Sundanese => "Sundanese",
                Self::Saurashtra => "Saurashtra",
                Self::Cham => "Cham",
                Self::OlChiki => "OlChiki",
                Self::Vai => "Vai",
                Self::Carian => "Carian",
                Self::Lycian => "Lycian",
                Self::Lydian => "Lydian",
                Self::Avestan => "Avestan",
                Self::Bamum => "Bamum",
                Self::EgyptianHieroglyphs => "EgyptianHieroglyphs",
                Self::ImperialAramaic => "ImperialAramaic",
                Self::InscriptionalPahlavi => "InscriptionalPahlavi",
                Self::InscriptionalParthian => "InscriptionalParthian",
                Self::Javanese => "Javanese",
                Self::Kaithi => "Kaithi",
                Self::Lisu => "Lisu",
                Self::MeeteiMayek => "MeeteiMayek",
                Self::OldSouthArabian => "OldSouthArabian",
                Self::OldTurkic => "OldTurkic",
                Self::Samaritan => "Samaritan",
                Self::TaiTham => "TaiTham",
                Self::TaiViet => "TaiViet",
                Self::Batak => "Batak",
                Self::Brahmi => "Brahmi",
                Self::Mandaic => "Mandaic",
                Self::Chakma => "Chakma",
                Self::MeroiticCursive => "MeroiticCursive",
                Self::MeroiticHieroglyphs => "MeroiticHieroglyphs",
                Self::Miao => "Miao",
                Self::Sharada => "Sharada",
                Self::SoraSompeng => "SoraSompeng",
                Self::Takri => "Takri",
                Self::BassaVah => "BassaVah",
                Self::CaucasianAlbanian => "CaucasianAlbanian",
                Self::Duployan => "Duployan",
                Self::Elbasan => "Elbasan",
                Self::Grantha => "Grantha",
                Self::Khojki => "Khojki",
                Self::Khudawadi => "Khudawadi",
                Self::LinearA => "LinearA",
                Self::Mahajani => "Mahajani",
                Self::Manichaean => "Manichaean",
                Self::MendeKikakui => "MendeKikakui",
                Self::Modi => "Modi",
                Self::Mro => "Mro",
                Self::Nabataean => "Nabataean",
                Self::OldNorthArabian => "OldNorthArabian",
                Self::OldPermic => "OldPermic",
                Self::PahawhHmong => "PahawhHmong",
                Self::Palmyrene => "Palmyrene",
                Self::PauCinHau => "PauCinHau",
                Self::PsalterPahlavi => "PsalterPahlavi",
                Self::Siddham => "Siddham",
                Self::Tirhuta => "Tirhuta",
                Self::WarangCiti => "WarangCiti",
                Self::Ahom => "Ahom",
                Self::AnatolianHieroglyphs => "AnatolianHieroglyphs",
                Self::Hatran => "Hatran",
                Self::Multani => "Multani",
                Self::OldHungarian => "OldHungarian",
                Self::Signwriting => "Signwriting",
                Self::Adlam => "Adlam",
                Self::Bhaiksuki => "Bhaiksuki",
                Self::Marchen => "Marchen",
                Self::Newa => "Newa",
                Self::Osage => "Osage",
                Self::Tangut => "Tangut",
                Self::MasaramGondi => "MasaramGondi",
                Self::Nushu => "Nushu",
                Self::Soyombo => "Soyombo",
                Self::ZanabazarSquare => "ZanabazarSquare",
                Self::Dogra => "Dogra",
                Self::GunjalaGondi => "GunjalaGondi",
                Self::HanifiRohingya => "HanifiRohingya",
                Self::Makasar => "Makasar",
                Self::Medefaidrin => "Medefaidrin",
                Self::OldSogdian => "OldSogdian",
                Self::Sogdian => "Sogdian",
                Self::Elymaic => "Elymaic",
                Self::Nandinagari => "Nandinagari",
                Self::NyiakengPuachueHmong => "NyiakengPuachueHmong",
                Self::Wancho => "Wancho",
                Self::Chorasmian => "Chorasmian",
                Self::DivesAkuru => "DivesAkuru",
                Self::KhitanSmallScript => "KhitanSmallScript",
                Self::Yezidi => "Yezidi",
                #[cfg(any(feature = "v2_72", feature = "dox"))]
                Self::CyproMinoan => "CyproMinoan",
                #[cfg(any(feature = "v2_72", feature = "dox"))]
                Self::OldUyghur => "OldUyghur",
                #[cfg(any(feature = "v2_72", feature = "dox"))]
                Self::Tangsa => "Tangsa",
                #[cfg(any(feature = "v2_72", feature = "dox"))]
                Self::Toto => "Toto",
                #[cfg(any(feature = "v2_72", feature = "dox"))]
                Self::Vithkuqi => "Vithkuqi",
                #[cfg(any(feature = "v2_72", feature = "dox"))]
                Self::Math => "Math",
                #[cfg(any(feature = "v2_74", feature = "dox"))]
                Self::Kawi => "Kawi",
                #[cfg(any(feature = "v2_74", feature = "dox"))]
                Self::NagMundari => "NagMundari",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for UnicodeScript {
    type GlibType = ffi::GUnicodeScript;

    fn into_glib(self) -> ffi::GUnicodeScript {
        match self {
            Self::InvalidCode => ffi::G_UNICODE_SCRIPT_INVALID_CODE,
            Self::Common => ffi::G_UNICODE_SCRIPT_COMMON,
            Self::Inherited => ffi::G_UNICODE_SCRIPT_INHERITED,
            Self::Arabic => ffi::G_UNICODE_SCRIPT_ARABIC,
            Self::Armenian => ffi::G_UNICODE_SCRIPT_ARMENIAN,
            Self::Bengali => ffi::G_UNICODE_SCRIPT_BENGALI,
            Self::Bopomofo => ffi::G_UNICODE_SCRIPT_BOPOMOFO,
            Self::Cherokee => ffi::G_UNICODE_SCRIPT_CHEROKEE,
            Self::Coptic => ffi::G_UNICODE_SCRIPT_COPTIC,
            Self::Cyrillic => ffi::G_UNICODE_SCRIPT_CYRILLIC,
            Self::Deseret => ffi::G_UNICODE_SCRIPT_DESERET,
            Self::Devanagari => ffi::G_UNICODE_SCRIPT_DEVANAGARI,
            Self::Ethiopic => ffi::G_UNICODE_SCRIPT_ETHIOPIC,
            Self::Georgian => ffi::G_UNICODE_SCRIPT_GEORGIAN,
            Self::Gothic => ffi::G_UNICODE_SCRIPT_GOTHIC,
            Self::Greek => ffi::G_UNICODE_SCRIPT_GREEK,
            Self::Gujarati => ffi::G_UNICODE_SCRIPT_GUJARATI,
            Self::Gurmukhi => ffi::G_UNICODE_SCRIPT_GURMUKHI,
            Self::Han => ffi::G_UNICODE_SCRIPT_HAN,
            Self::Hangul => ffi::G_UNICODE_SCRIPT_HANGUL,
            Self::Hebrew => ffi::G_UNICODE_SCRIPT_HEBREW,
            Self::Hiragana => ffi::G_UNICODE_SCRIPT_HIRAGANA,
            Self::Kannada => ffi::G_UNICODE_SCRIPT_KANNADA,
            Self::Katakana => ffi::G_UNICODE_SCRIPT_KATAKANA,
            Self::Khmer => ffi::G_UNICODE_SCRIPT_KHMER,
            Self::Lao => ffi::G_UNICODE_SCRIPT_LAO,
            Self::Latin => ffi::G_UNICODE_SCRIPT_LATIN,
            Self::Malayalam => ffi::G_UNICODE_SCRIPT_MALAYALAM,
            Self::Mongolian => ffi::G_UNICODE_SCRIPT_MONGOLIAN,
            Self::Myanmar => ffi::G_UNICODE_SCRIPT_MYANMAR,
            Self::Ogham => ffi::G_UNICODE_SCRIPT_OGHAM,
            Self::OldItalic => ffi::G_UNICODE_SCRIPT_OLD_ITALIC,
            Self::Oriya => ffi::G_UNICODE_SCRIPT_ORIYA,
            Self::Runic => ffi::G_UNICODE_SCRIPT_RUNIC,
            Self::Sinhala => ffi::G_UNICODE_SCRIPT_SINHALA,
            Self::Syriac => ffi::G_UNICODE_SCRIPT_SYRIAC,
            Self::Tamil => ffi::G_UNICODE_SCRIPT_TAMIL,
            Self::Telugu => ffi::G_UNICODE_SCRIPT_TELUGU,
            Self::Thaana => ffi::G_UNICODE_SCRIPT_THAANA,
            Self::Thai => ffi::G_UNICODE_SCRIPT_THAI,
            Self::Tibetan => ffi::G_UNICODE_SCRIPT_TIBETAN,
            Self::CanadianAboriginal => ffi::G_UNICODE_SCRIPT_CANADIAN_ABORIGINAL,
            Self::Yi => ffi::G_UNICODE_SCRIPT_YI,
            Self::Tagalog => ffi::G_UNICODE_SCRIPT_TAGALOG,
            Self::Hanunoo => ffi::G_UNICODE_SCRIPT_HANUNOO,
            Self::Buhid => ffi::G_UNICODE_SCRIPT_BUHID,
            Self::Tagbanwa => ffi::G_UNICODE_SCRIPT_TAGBANWA,
            Self::Braille => ffi::G_UNICODE_SCRIPT_BRAILLE,
            Self::Cypriot => ffi::G_UNICODE_SCRIPT_CYPRIOT,
            Self::Limbu => ffi::G_UNICODE_SCRIPT_LIMBU,
            Self::Osmanya => ffi::G_UNICODE_SCRIPT_OSMANYA,
            Self::Shavian => ffi::G_UNICODE_SCRIPT_SHAVIAN,
            Self::LinearB => ffi::G_UNICODE_SCRIPT_LINEAR_B,
            Self::TaiLe => ffi::G_UNICODE_SCRIPT_TAI_LE,
            Self::Ugaritic => ffi::G_UNICODE_SCRIPT_UGARITIC,
            Self::NewTaiLue => ffi::G_UNICODE_SCRIPT_NEW_TAI_LUE,
            Self::Buginese => ffi::G_UNICODE_SCRIPT_BUGINESE,
            Self::Glagolitic => ffi::G_UNICODE_SCRIPT_GLAGOLITIC,
            Self::Tifinagh => ffi::G_UNICODE_SCRIPT_TIFINAGH,
            Self::SylotiNagri => ffi::G_UNICODE_SCRIPT_SYLOTI_NAGRI,
            Self::OldPersian => ffi::G_UNICODE_SCRIPT_OLD_PERSIAN,
            Self::Kharoshthi => ffi::G_UNICODE_SCRIPT_KHAROSHTHI,
            Self::Unknown => ffi::G_UNICODE_SCRIPT_UNKNOWN,
            Self::Balinese => ffi::G_UNICODE_SCRIPT_BALINESE,
            Self::Cuneiform => ffi::G_UNICODE_SCRIPT_CUNEIFORM,
            Self::Phoenician => ffi::G_UNICODE_SCRIPT_PHOENICIAN,
            Self::PhagsPa => ffi::G_UNICODE_SCRIPT_PHAGS_PA,
            Self::Nko => ffi::G_UNICODE_SCRIPT_NKO,
            Self::KayahLi => ffi::G_UNICODE_SCRIPT_KAYAH_LI,
            Self::Lepcha => ffi::G_UNICODE_SCRIPT_LEPCHA,
            Self::Rejang => ffi::G_UNICODE_SCRIPT_REJANG,
            Self::Sundanese => ffi::G_UNICODE_SCRIPT_SUNDANESE,
            Self::Saurashtra => ffi::G_UNICODE_SCRIPT_SAURASHTRA,
            Self::Cham => ffi::G_UNICODE_SCRIPT_CHAM,
            Self::OlChiki => ffi::G_UNICODE_SCRIPT_OL_CHIKI,
            Self::Vai => ffi::G_UNICODE_SCRIPT_VAI,
            Self::Carian => ffi::G_UNICODE_SCRIPT_CARIAN,
            Self::Lycian => ffi::G_UNICODE_SCRIPT_LYCIAN,
            Self::Lydian => ffi::G_UNICODE_SCRIPT_LYDIAN,
            Self::Avestan => ffi::G_UNICODE_SCRIPT_AVESTAN,
            Self::Bamum => ffi::G_UNICODE_SCRIPT_BAMUM,
            Self::EgyptianHieroglyphs => ffi::G_UNICODE_SCRIPT_EGYPTIAN_HIEROGLYPHS,
            Self::ImperialAramaic => ffi::G_UNICODE_SCRIPT_IMPERIAL_ARAMAIC,
            Self::InscriptionalPahlavi => ffi::G_UNICODE_SCRIPT_INSCRIPTIONAL_PAHLAVI,
            Self::InscriptionalParthian => ffi::G_UNICODE_SCRIPT_INSCRIPTIONAL_PARTHIAN,
            Self::Javanese => ffi::G_UNICODE_SCRIPT_JAVANESE,
            Self::Kaithi => ffi::G_UNICODE_SCRIPT_KAITHI,
            Self::Lisu => ffi::G_UNICODE_SCRIPT_LISU,
            Self::MeeteiMayek => ffi::G_UNICODE_SCRIPT_MEETEI_MAYEK,
            Self::OldSouthArabian => ffi::G_UNICODE_SCRIPT_OLD_SOUTH_ARABIAN,
            Self::OldTurkic => ffi::G_UNICODE_SCRIPT_OLD_TURKIC,
            Self::Samaritan => ffi::G_UNICODE_SCRIPT_SAMARITAN,
            Self::TaiTham => ffi::G_UNICODE_SCRIPT_TAI_THAM,
            Self::TaiViet => ffi::G_UNICODE_SCRIPT_TAI_VIET,
            Self::Batak => ffi::G_UNICODE_SCRIPT_BATAK,
            Self::Brahmi => ffi::G_UNICODE_SCRIPT_BRAHMI,
            Self::Mandaic => ffi::G_UNICODE_SCRIPT_MANDAIC,
            Self::Chakma => ffi::G_UNICODE_SCRIPT_CHAKMA,
            Self::MeroiticCursive => ffi::G_UNICODE_SCRIPT_MEROITIC_CURSIVE,
            Self::MeroiticHieroglyphs => ffi::G_UNICODE_SCRIPT_MEROITIC_HIEROGLYPHS,
            Self::Miao => ffi::G_UNICODE_SCRIPT_MIAO,
            Self::Sharada => ffi::G_UNICODE_SCRIPT_SHARADA,
            Self::SoraSompeng => ffi::G_UNICODE_SCRIPT_SORA_SOMPENG,
            Self::Takri => ffi::G_UNICODE_SCRIPT_TAKRI,
            Self::BassaVah => ffi::G_UNICODE_SCRIPT_BASSA_VAH,
            Self::CaucasianAlbanian => ffi::G_UNICODE_SCRIPT_CAUCASIAN_ALBANIAN,
            Self::Duployan => ffi::G_UNICODE_SCRIPT_DUPLOYAN,
            Self::Elbasan => ffi::G_UNICODE_SCRIPT_ELBASAN,
            Self::Grantha => ffi::G_UNICODE_SCRIPT_GRANTHA,
            Self::Khojki => ffi::G_UNICODE_SCRIPT_KHOJKI,
            Self::Khudawadi => ffi::G_UNICODE_SCRIPT_KHUDAWADI,
            Self::LinearA => ffi::G_UNICODE_SCRIPT_LINEAR_A,
            Self::Mahajani => ffi::G_UNICODE_SCRIPT_MAHAJANI,
            Self::Manichaean => ffi::G_UNICODE_SCRIPT_MANICHAEAN,
            Self::MendeKikakui => ffi::G_UNICODE_SCRIPT_MENDE_KIKAKUI,
            Self::Modi => ffi::G_UNICODE_SCRIPT_MODI,
            Self::Mro => ffi::G_UNICODE_SCRIPT_MRO,
            Self::Nabataean => ffi::G_UNICODE_SCRIPT_NABATAEAN,
            Self::OldNorthArabian => ffi::G_UNICODE_SCRIPT_OLD_NORTH_ARABIAN,
            Self::OldPermic => ffi::G_UNICODE_SCRIPT_OLD_PERMIC,
            Self::PahawhHmong => ffi::G_UNICODE_SCRIPT_PAHAWH_HMONG,
            Self::Palmyrene => ffi::G_UNICODE_SCRIPT_PALMYRENE,
            Self::PauCinHau => ffi::G_UNICODE_SCRIPT_PAU_CIN_HAU,
            Self::PsalterPahlavi => ffi::G_UNICODE_SCRIPT_PSALTER_PAHLAVI,
            Self::Siddham => ffi::G_UNICODE_SCRIPT_SIDDHAM,
            Self::Tirhuta => ffi::G_UNICODE_SCRIPT_TIRHUTA,
            Self::WarangCiti => ffi::G_UNICODE_SCRIPT_WARANG_CITI,
            Self::Ahom => ffi::G_UNICODE_SCRIPT_AHOM,
            Self::AnatolianHieroglyphs => ffi::G_UNICODE_SCRIPT_ANATOLIAN_HIEROGLYPHS,
            Self::Hatran => ffi::G_UNICODE_SCRIPT_HATRAN,
            Self::Multani => ffi::G_UNICODE_SCRIPT_MULTANI,
            Self::OldHungarian => ffi::G_UNICODE_SCRIPT_OLD_HUNGARIAN,
            Self::Signwriting => ffi::G_UNICODE_SCRIPT_SIGNWRITING,
            Self::Adlam => ffi::G_UNICODE_SCRIPT_ADLAM,
            Self::Bhaiksuki => ffi::G_UNICODE_SCRIPT_BHAIKSUKI,
            Self::Marchen => ffi::G_UNICODE_SCRIPT_MARCHEN,
            Self::Newa => ffi::G_UNICODE_SCRIPT_NEWA,
            Self::Osage => ffi::G_UNICODE_SCRIPT_OSAGE,
            Self::Tangut => ffi::G_UNICODE_SCRIPT_TANGUT,
            Self::MasaramGondi => ffi::G_UNICODE_SCRIPT_MASARAM_GONDI,
            Self::Nushu => ffi::G_UNICODE_SCRIPT_NUSHU,
            Self::Soyombo => ffi::G_UNICODE_SCRIPT_SOYOMBO,
            Self::ZanabazarSquare => ffi::G_UNICODE_SCRIPT_ZANABAZAR_SQUARE,
            Self::Dogra => ffi::G_UNICODE_SCRIPT_DOGRA,
            Self::GunjalaGondi => ffi::G_UNICODE_SCRIPT_GUNJALA_GONDI,
            Self::HanifiRohingya => ffi::G_UNICODE_SCRIPT_HANIFI_ROHINGYA,
            Self::Makasar => ffi::G_UNICODE_SCRIPT_MAKASAR,
            Self::Medefaidrin => ffi::G_UNICODE_SCRIPT_MEDEFAIDRIN,
            Self::OldSogdian => ffi::G_UNICODE_SCRIPT_OLD_SOGDIAN,
            Self::Sogdian => ffi::G_UNICODE_SCRIPT_SOGDIAN,
            Self::Elymaic => ffi::G_UNICODE_SCRIPT_ELYMAIC,
            Self::Nandinagari => ffi::G_UNICODE_SCRIPT_NANDINAGARI,
            Self::NyiakengPuachueHmong => ffi::G_UNICODE_SCRIPT_NYIAKENG_PUACHUE_HMONG,
            Self::Wancho => ffi::G_UNICODE_SCRIPT_WANCHO,
            Self::Chorasmian => ffi::G_UNICODE_SCRIPT_CHORASMIAN,
            Self::DivesAkuru => ffi::G_UNICODE_SCRIPT_DIVES_AKURU,
            Self::KhitanSmallScript => ffi::G_UNICODE_SCRIPT_KHITAN_SMALL_SCRIPT,
            Self::Yezidi => ffi::G_UNICODE_SCRIPT_YEZIDI,
            #[cfg(any(feature = "v2_72", feature = "dox"))]
            Self::CyproMinoan => ffi::G_UNICODE_SCRIPT_CYPRO_MINOAN,
            #[cfg(any(feature = "v2_72", feature = "dox"))]
            Self::OldUyghur => ffi::G_UNICODE_SCRIPT_OLD_UYGHUR,
            #[cfg(any(feature = "v2_72", feature = "dox"))]
            Self::Tangsa => ffi::G_UNICODE_SCRIPT_TANGSA,
            #[cfg(any(feature = "v2_72", feature = "dox"))]
            Self::Toto => ffi::G_UNICODE_SCRIPT_TOTO,
            #[cfg(any(feature = "v2_72", feature = "dox"))]
            Self::Vithkuqi => ffi::G_UNICODE_SCRIPT_VITHKUQI,
            #[cfg(any(feature = "v2_72", feature = "dox"))]
            Self::Math => ffi::G_UNICODE_SCRIPT_MATH,
            #[cfg(any(feature = "v2_74", feature = "dox"))]
            Self::Kawi => ffi::G_UNICODE_SCRIPT_KAWI,
            #[cfg(any(feature = "v2_74", feature = "dox"))]
            Self::NagMundari => ffi::G_UNICODE_SCRIPT_NAG_MUNDARI,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GUnicodeScript> for UnicodeScript {
    unsafe fn from_glib(value: ffi::GUnicodeScript) -> Self {
        match value {
            ffi::G_UNICODE_SCRIPT_INVALID_CODE => Self::InvalidCode,
            ffi::G_UNICODE_SCRIPT_COMMON => Self::Common,
            ffi::G_UNICODE_SCRIPT_INHERITED => Self::Inherited,
            ffi::G_UNICODE_SCRIPT_ARABIC => Self::Arabic,
            ffi::G_UNICODE_SCRIPT_ARMENIAN => Self::Armenian,
            ffi::G_UNICODE_SCRIPT_BENGALI => Self::Bengali,
            ffi::G_UNICODE_SCRIPT_BOPOMOFO => Self::Bopomofo,
            ffi::G_UNICODE_SCRIPT_CHEROKEE => Self::Cherokee,
            ffi::G_UNICODE_SCRIPT_COPTIC => Self::Coptic,
            ffi::G_UNICODE_SCRIPT_CYRILLIC => Self::Cyrillic,
            ffi::G_UNICODE_SCRIPT_DESERET => Self::Deseret,
            ffi::G_UNICODE_SCRIPT_DEVANAGARI => Self::Devanagari,
            ffi::G_UNICODE_SCRIPT_ETHIOPIC => Self::Ethiopic,
            ffi::G_UNICODE_SCRIPT_GEORGIAN => Self::Georgian,
            ffi::G_UNICODE_SCRIPT_GOTHIC => Self::Gothic,
            ffi::G_UNICODE_SCRIPT_GREEK => Self::Greek,
            ffi::G_UNICODE_SCRIPT_GUJARATI => Self::Gujarati,
            ffi::G_UNICODE_SCRIPT_GURMUKHI => Self::Gurmukhi,
            ffi::G_UNICODE_SCRIPT_HAN => Self::Han,
            ffi::G_UNICODE_SCRIPT_HANGUL => Self::Hangul,
            ffi::G_UNICODE_SCRIPT_HEBREW => Self::Hebrew,
            ffi::G_UNICODE_SCRIPT_HIRAGANA => Self::Hiragana,
            ffi::G_UNICODE_SCRIPT_KANNADA => Self::Kannada,
            ffi::G_UNICODE_SCRIPT_KATAKANA => Self::Katakana,
            ffi::G_UNICODE_SCRIPT_KHMER => Self::Khmer,
            ffi::G_UNICODE_SCRIPT_LAO => Self::Lao,
            ffi::G_UNICODE_SCRIPT_LATIN => Self::Latin,
            ffi::G_UNICODE_SCRIPT_MALAYALAM => Self::Malayalam,
            ffi::G_UNICODE_SCRIPT_MONGOLIAN => Self::Mongolian,
            ffi::G_UNICODE_SCRIPT_MYANMAR => Self::Myanmar,
            ffi::G_UNICODE_SCRIPT_OGHAM => Self::Ogham,
            ffi::G_UNICODE_SCRIPT_OLD_ITALIC => Self::OldItalic,
            ffi::G_UNICODE_SCRIPT_ORIYA => Self::Oriya,
            ffi::G_UNICODE_SCRIPT_RUNIC => Self::Runic,
            ffi::G_UNICODE_SCRIPT_SINHALA => Self::Sinhala,
            ffi::G_UNICODE_SCRIPT_SYRIAC => Self::Syriac,
            ffi::G_UNICODE_SCRIPT_TAMIL => Self::Tamil,
            ffi::G_UNICODE_SCRIPT_TELUGU => Self::Telugu,
            ffi::G_UNICODE_SCRIPT_THAANA => Self::Thaana,
            ffi::G_UNICODE_SCRIPT_THAI => Self::Thai,
            ffi::G_UNICODE_SCRIPT_TIBETAN => Self::Tibetan,
            ffi::G_UNICODE_SCRIPT_CANADIAN_ABORIGINAL => Self::CanadianAboriginal,
            ffi::G_UNICODE_SCRIPT_YI => Self::Yi,
            ffi::G_UNICODE_SCRIPT_TAGALOG => Self::Tagalog,
            ffi::G_UNICODE_SCRIPT_HANUNOO => Self::Hanunoo,
            ffi::G_UNICODE_SCRIPT_BUHID => Self::Buhid,
            ffi::G_UNICODE_SCRIPT_TAGBANWA => Self::Tagbanwa,
            ffi::G_UNICODE_SCRIPT_BRAILLE => Self::Braille,
            ffi::G_UNICODE_SCRIPT_CYPRIOT => Self::Cypriot,
            ffi::G_UNICODE_SCRIPT_LIMBU => Self::Limbu,
            ffi::G_UNICODE_SCRIPT_OSMANYA => Self::Osmanya,
            ffi::G_UNICODE_SCRIPT_SHAVIAN => Self::Shavian,
            ffi::G_UNICODE_SCRIPT_LINEAR_B => Self::LinearB,
            ffi::G_UNICODE_SCRIPT_TAI_LE => Self::TaiLe,
            ffi::G_UNICODE_SCRIPT_UGARITIC => Self::Ugaritic,
            ffi::G_UNICODE_SCRIPT_NEW_TAI_LUE => Self::NewTaiLue,
            ffi::G_UNICODE_SCRIPT_BUGINESE => Self::Buginese,
            ffi::G_UNICODE_SCRIPT_GLAGOLITIC => Self::Glagolitic,
            ffi::G_UNICODE_SCRIPT_TIFINAGH => Self::Tifinagh,
            ffi::G_UNICODE_SCRIPT_SYLOTI_NAGRI => Self::SylotiNagri,
            ffi::G_UNICODE_SCRIPT_OLD_PERSIAN => Self::OldPersian,
            ffi::G_UNICODE_SCRIPT_KHAROSHTHI => Self::Kharoshthi,
            ffi::G_UNICODE_SCRIPT_UNKNOWN => Self::Unknown,
            ffi::G_UNICODE_SCRIPT_BALINESE => Self::Balinese,
            ffi::G_UNICODE_SCRIPT_CUNEIFORM => Self::Cuneiform,
            ffi::G_UNICODE_SCRIPT_PHOENICIAN => Self::Phoenician,
            ffi::G_UNICODE_SCRIPT_PHAGS_PA => Self::PhagsPa,
            ffi::G_UNICODE_SCRIPT_NKO => Self::Nko,
            ffi::G_UNICODE_SCRIPT_KAYAH_LI => Self::KayahLi,
            ffi::G_UNICODE_SCRIPT_LEPCHA => Self::Lepcha,
            ffi::G_UNICODE_SCRIPT_REJANG => Self::Rejang,
            ffi::G_UNICODE_SCRIPT_SUNDANESE => Self::Sundanese,
            ffi::G_UNICODE_SCRIPT_SAURASHTRA => Self::Saurashtra,
            ffi::G_UNICODE_SCRIPT_CHAM => Self::Cham,
            ffi::G_UNICODE_SCRIPT_OL_CHIKI => Self::OlChiki,
            ffi::G_UNICODE_SCRIPT_VAI => Self::Vai,
            ffi::G_UNICODE_SCRIPT_CARIAN => Self::Carian,
            ffi::G_UNICODE_SCRIPT_LYCIAN => Self::Lycian,
            ffi::G_UNICODE_SCRIPT_LYDIAN => Self::Lydian,
            ffi::G_UNICODE_SCRIPT_AVESTAN => Self::Avestan,
            ffi::G_UNICODE_SCRIPT_BAMUM => Self::Bamum,
            ffi::G_UNICODE_SCRIPT_EGYPTIAN_HIEROGLYPHS => Self::EgyptianHieroglyphs,
            ffi::G_UNICODE_SCRIPT_IMPERIAL_ARAMAIC => Self::ImperialAramaic,
            ffi::G_UNICODE_SCRIPT_INSCRIPTIONAL_PAHLAVI => Self::InscriptionalPahlavi,
            ffi::G_UNICODE_SCRIPT_INSCRIPTIONAL_PARTHIAN => Self::InscriptionalParthian,
            ffi::G_UNICODE_SCRIPT_JAVANESE => Self::Javanese,
            ffi::G_UNICODE_SCRIPT_KAITHI => Self::Kaithi,
            ffi::G_UNICODE_SCRIPT_LISU => Self::Lisu,
            ffi::G_UNICODE_SCRIPT_MEETEI_MAYEK => Self::MeeteiMayek,
            ffi::G_UNICODE_SCRIPT_OLD_SOUTH_ARABIAN => Self::OldSouthArabian,
            ffi::G_UNICODE_SCRIPT_OLD_TURKIC => Self::OldTurkic,
            ffi::G_UNICODE_SCRIPT_SAMARITAN => Self::Samaritan,
            ffi::G_UNICODE_SCRIPT_TAI_THAM => Self::TaiTham,
            ffi::G_UNICODE_SCRIPT_TAI_VIET => Self::TaiViet,
            ffi::G_UNICODE_SCRIPT_BATAK => Self::Batak,
            ffi::G_UNICODE_SCRIPT_BRAHMI => Self::Brahmi,
            ffi::G_UNICODE_SCRIPT_MANDAIC => Self::Mandaic,
            ffi::G_UNICODE_SCRIPT_CHAKMA => Self::Chakma,
            ffi::G_UNICODE_SCRIPT_MEROITIC_CURSIVE => Self::MeroiticCursive,
            ffi::G_UNICODE_SCRIPT_MEROITIC_HIEROGLYPHS => Self::MeroiticHieroglyphs,
            ffi::G_UNICODE_SCRIPT_MIAO => Self::Miao,
            ffi::G_UNICODE_SCRIPT_SHARADA => Self::Sharada,
            ffi::G_UNICODE_SCRIPT_SORA_SOMPENG => Self::SoraSompeng,
            ffi::G_UNICODE_SCRIPT_TAKRI => Self::Takri,
            ffi::G_UNICODE_SCRIPT_BASSA_VAH => Self::BassaVah,
            ffi::G_UNICODE_SCRIPT_CAUCASIAN_ALBANIAN => Self::CaucasianAlbanian,
            ffi::G_UNICODE_SCRIPT_DUPLOYAN => Self::Duployan,
            ffi::G_UNICODE_SCRIPT_ELBASAN => Self::Elbasan,
            ffi::G_UNICODE_SCRIPT_GRANTHA => Self::Grantha,
            ffi::G_UNICODE_SCRIPT_KHOJKI => Self::Khojki,
            ffi::G_UNICODE_SCRIPT_KHUDAWADI => Self::Khudawadi,
            ffi::G_UNICODE_SCRIPT_LINEAR_A => Self::LinearA,
            ffi::G_UNICODE_SCRIPT_MAHAJANI => Self::Mahajani,
            ffi::G_UNICODE_SCRIPT_MANICHAEAN => Self::Manichaean,
            ffi::G_UNICODE_SCRIPT_MENDE_KIKAKUI => Self::MendeKikakui,
            ffi::G_UNICODE_SCRIPT_MODI => Self::Modi,
            ffi::G_UNICODE_SCRIPT_MRO => Self::Mro,
            ffi::G_UNICODE_SCRIPT_NABATAEAN => Self::Nabataean,
            ffi::G_UNICODE_SCRIPT_OLD_NORTH_ARABIAN => Self::OldNorthArabian,
            ffi::G_UNICODE_SCRIPT_OLD_PERMIC => Self::OldPermic,
            ffi::G_UNICODE_SCRIPT_PAHAWH_HMONG => Self::PahawhHmong,
            ffi::G_UNICODE_SCRIPT_PALMYRENE => Self::Palmyrene,
            ffi::G_UNICODE_SCRIPT_PAU_CIN_HAU => Self::PauCinHau,
            ffi::G_UNICODE_SCRIPT_PSALTER_PAHLAVI => Self::PsalterPahlavi,
            ffi::G_UNICODE_SCRIPT_SIDDHAM => Self::Siddham,
            ffi::G_UNICODE_SCRIPT_TIRHUTA => Self::Tirhuta,
            ffi::G_UNICODE_SCRIPT_WARANG_CITI => Self::WarangCiti,
            ffi::G_UNICODE_SCRIPT_AHOM => Self::Ahom,
            ffi::G_UNICODE_SCRIPT_ANATOLIAN_HIEROGLYPHS => Self::AnatolianHieroglyphs,
            ffi::G_UNICODE_SCRIPT_HATRAN => Self::Hatran,
            ffi::G_UNICODE_SCRIPT_MULTANI => Self::Multani,
            ffi::G_UNICODE_SCRIPT_OLD_HUNGARIAN => Self::OldHungarian,
            ffi::G_UNICODE_SCRIPT_SIGNWRITING => Self::Signwriting,
            ffi::G_UNICODE_SCRIPT_ADLAM => Self::Adlam,
            ffi::G_UNICODE_SCRIPT_BHAIKSUKI => Self::Bhaiksuki,
            ffi::G_UNICODE_SCRIPT_MARCHEN => Self::Marchen,
            ffi::G_UNICODE_SCRIPT_NEWA => Self::Newa,
            ffi::G_UNICODE_SCRIPT_OSAGE => Self::Osage,
            ffi::G_UNICODE_SCRIPT_TANGUT => Self::Tangut,
            ffi::G_UNICODE_SCRIPT_MASARAM_GONDI => Self::MasaramGondi,
            ffi::G_UNICODE_SCRIPT_NUSHU => Self::Nushu,
            ffi::G_UNICODE_SCRIPT_SOYOMBO => Self::Soyombo,
            ffi::G_UNICODE_SCRIPT_ZANABAZAR_SQUARE => Self::ZanabazarSquare,
            ffi::G_UNICODE_SCRIPT_DOGRA => Self::Dogra,
            ffi::G_UNICODE_SCRIPT_GUNJALA_GONDI => Self::GunjalaGondi,
            ffi::G_UNICODE_SCRIPT_HANIFI_ROHINGYA => Self::HanifiRohingya,
            ffi::G_UNICODE_SCRIPT_MAKASAR => Self::Makasar,
            ffi::G_UNICODE_SCRIPT_MEDEFAIDRIN => Self::Medefaidrin,
            ffi::G_UNICODE_SCRIPT_OLD_SOGDIAN => Self::OldSogdian,
            ffi::G_UNICODE_SCRIPT_SOGDIAN => Self::Sogdian,
            ffi::G_UNICODE_SCRIPT_ELYMAIC => Self::Elymaic,
            ffi::G_UNICODE_SCRIPT_NANDINAGARI => Self::Nandinagari,
            ffi::G_UNICODE_SCRIPT_NYIAKENG_PUACHUE_HMONG => Self::NyiakengPuachueHmong,
            ffi::G_UNICODE_SCRIPT_WANCHO => Self::Wancho,
            ffi::G_UNICODE_SCRIPT_CHORASMIAN => Self::Chorasmian,
            ffi::G_UNICODE_SCRIPT_DIVES_AKURU => Self::DivesAkuru,
            ffi::G_UNICODE_SCRIPT_KHITAN_SMALL_SCRIPT => Self::KhitanSmallScript,
            ffi::G_UNICODE_SCRIPT_YEZIDI => Self::Yezidi,
            #[cfg(any(feature = "v2_72", feature = "dox"))]
            ffi::G_UNICODE_SCRIPT_CYPRO_MINOAN => Self::CyproMinoan,
            #[cfg(any(feature = "v2_72", feature = "dox"))]
            ffi::G_UNICODE_SCRIPT_OLD_UYGHUR => Self::OldUyghur,
            #[cfg(any(feature = "v2_72", feature = "dox"))]
            ffi::G_UNICODE_SCRIPT_TANGSA => Self::Tangsa,
            #[cfg(any(feature = "v2_72", feature = "dox"))]
            ffi::G_UNICODE_SCRIPT_TOTO => Self::Toto,
            #[cfg(any(feature = "v2_72", feature = "dox"))]
            ffi::G_UNICODE_SCRIPT_VITHKUQI => Self::Vithkuqi,
            #[cfg(any(feature = "v2_72", feature = "dox"))]
            ffi::G_UNICODE_SCRIPT_MATH => Self::Math,
            #[cfg(any(feature = "v2_74", feature = "dox"))]
            ffi::G_UNICODE_SCRIPT_KAWI => Self::Kawi,
            #[cfg(any(feature = "v2_74", feature = "dox"))]
            ffi::G_UNICODE_SCRIPT_NAG_MUNDARI => Self::NagMundari,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v2_66", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_66")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GUriError")]
pub enum UriError {
    #[doc(alias = "G_URI_ERROR_FAILED")]
    Failed,
    #[doc(alias = "G_URI_ERROR_BAD_SCHEME")]
    BadScheme,
    #[doc(alias = "G_URI_ERROR_BAD_USER")]
    BadUser,
    #[doc(alias = "G_URI_ERROR_BAD_PASSWORD")]
    BadPassword,
    #[doc(alias = "G_URI_ERROR_BAD_AUTH_PARAMS")]
    BadAuthParams,
    #[doc(alias = "G_URI_ERROR_BAD_HOST")]
    BadHost,
    #[doc(alias = "G_URI_ERROR_BAD_PORT")]
    BadPort,
    #[doc(alias = "G_URI_ERROR_BAD_PATH")]
    BadPath,
    #[doc(alias = "G_URI_ERROR_BAD_QUERY")]
    BadQuery,
    #[doc(alias = "G_URI_ERROR_BAD_FRAGMENT")]
    BadFragment,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v2_66", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_66")))]
impl fmt::Display for UriError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "UriError::{}",
            match *self {
                Self::Failed => "Failed",
                Self::BadScheme => "BadScheme",
                Self::BadUser => "BadUser",
                Self::BadPassword => "BadPassword",
                Self::BadAuthParams => "BadAuthParams",
                Self::BadHost => "BadHost",
                Self::BadPort => "BadPort",
                Self::BadPath => "BadPath",
                Self::BadQuery => "BadQuery",
                Self::BadFragment => "BadFragment",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v2_66", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_66")))]
#[doc(hidden)]
impl IntoGlib for UriError {
    type GlibType = ffi::GUriError;

    fn into_glib(self) -> ffi::GUriError {
        match self {
            Self::Failed => ffi::G_URI_ERROR_FAILED,
            Self::BadScheme => ffi::G_URI_ERROR_BAD_SCHEME,
            Self::BadUser => ffi::G_URI_ERROR_BAD_USER,
            Self::BadPassword => ffi::G_URI_ERROR_BAD_PASSWORD,
            Self::BadAuthParams => ffi::G_URI_ERROR_BAD_AUTH_PARAMS,
            Self::BadHost => ffi::G_URI_ERROR_BAD_HOST,
            Self::BadPort => ffi::G_URI_ERROR_BAD_PORT,
            Self::BadPath => ffi::G_URI_ERROR_BAD_PATH,
            Self::BadQuery => ffi::G_URI_ERROR_BAD_QUERY,
            Self::BadFragment => ffi::G_URI_ERROR_BAD_FRAGMENT,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v2_66", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_66")))]
#[doc(hidden)]
impl FromGlib<ffi::GUriError> for UriError {
    unsafe fn from_glib(value: ffi::GUriError) -> Self {
        match value {
            ffi::G_URI_ERROR_FAILED => Self::Failed,
            ffi::G_URI_ERROR_BAD_SCHEME => Self::BadScheme,
            ffi::G_URI_ERROR_BAD_USER => Self::BadUser,
            ffi::G_URI_ERROR_BAD_PASSWORD => Self::BadPassword,
            ffi::G_URI_ERROR_BAD_AUTH_PARAMS => Self::BadAuthParams,
            ffi::G_URI_ERROR_BAD_HOST => Self::BadHost,
            ffi::G_URI_ERROR_BAD_PORT => Self::BadPort,
            ffi::G_URI_ERROR_BAD_PATH => Self::BadPath,
            ffi::G_URI_ERROR_BAD_QUERY => Self::BadQuery,
            ffi::G_URI_ERROR_BAD_FRAGMENT => Self::BadFragment,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v2_66", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_66")))]
impl ErrorDomain for UriError {
    fn domain() -> Quark {
        unsafe { from_glib(ffi::g_uri_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        match code {
            ffi::G_URI_ERROR_FAILED => Some(Self::Failed),
            ffi::G_URI_ERROR_BAD_SCHEME => Some(Self::BadScheme),
            ffi::G_URI_ERROR_BAD_USER => Some(Self::BadUser),
            ffi::G_URI_ERROR_BAD_PASSWORD => Some(Self::BadPassword),
            ffi::G_URI_ERROR_BAD_AUTH_PARAMS => Some(Self::BadAuthParams),
            ffi::G_URI_ERROR_BAD_HOST => Some(Self::BadHost),
            ffi::G_URI_ERROR_BAD_PORT => Some(Self::BadPort),
            ffi::G_URI_ERROR_BAD_PATH => Some(Self::BadPath),
            ffi::G_URI_ERROR_BAD_QUERY => Some(Self::BadQuery),
            ffi::G_URI_ERROR_BAD_FRAGMENT => Some(Self::BadFragment),
            _ => Some(Self::Failed),
        }
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "GVariantClass")]
pub enum VariantClass {
    #[doc(alias = "G_VARIANT_CLASS_BOOLEAN")]
    Boolean,
    #[doc(alias = "G_VARIANT_CLASS_BYTE")]
    Byte,
    #[doc(alias = "G_VARIANT_CLASS_INT16")]
    Int16,
    #[doc(alias = "G_VARIANT_CLASS_UINT16")]
    Uint16,
    #[doc(alias = "G_VARIANT_CLASS_INT32")]
    Int32,
    #[doc(alias = "G_VARIANT_CLASS_UINT32")]
    Uint32,
    #[doc(alias = "G_VARIANT_CLASS_INT64")]
    Int64,
    #[doc(alias = "G_VARIANT_CLASS_UINT64")]
    Uint64,
    #[doc(alias = "G_VARIANT_CLASS_HANDLE")]
    Handle,
    #[doc(alias = "G_VARIANT_CLASS_DOUBLE")]
    Double,
    #[doc(alias = "G_VARIANT_CLASS_STRING")]
    String,
    #[doc(alias = "G_VARIANT_CLASS_OBJECT_PATH")]
    ObjectPath,
    #[doc(alias = "G_VARIANT_CLASS_SIGNATURE")]
    Signature,
    #[doc(alias = "G_VARIANT_CLASS_VARIANT")]
    Variant,
    #[doc(alias = "G_VARIANT_CLASS_MAYBE")]
    Maybe,
    #[doc(alias = "G_VARIANT_CLASS_ARRAY")]
    Array,
    #[doc(alias = "G_VARIANT_CLASS_TUPLE")]
    Tuple,
    #[doc(alias = "G_VARIANT_CLASS_DICT_ENTRY")]
    DictEntry,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for VariantClass {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "VariantClass::{}",
            match *self {
                Self::Boolean => "Boolean",
                Self::Byte => "Byte",
                Self::Int16 => "Int16",
                Self::Uint16 => "Uint16",
                Self::Int32 => "Int32",
                Self::Uint32 => "Uint32",
                Self::Int64 => "Int64",
                Self::Uint64 => "Uint64",
                Self::Handle => "Handle",
                Self::Double => "Double",
                Self::String => "String",
                Self::ObjectPath => "ObjectPath",
                Self::Signature => "Signature",
                Self::Variant => "Variant",
                Self::Maybe => "Maybe",
                Self::Array => "Array",
                Self::Tuple => "Tuple",
                Self::DictEntry => "DictEntry",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for VariantClass {
    type GlibType = ffi::GVariantClass;

    fn into_glib(self) -> ffi::GVariantClass {
        match self {
            Self::Boolean => ffi::G_VARIANT_CLASS_BOOLEAN,
            Self::Byte => ffi::G_VARIANT_CLASS_BYTE,
            Self::Int16 => ffi::G_VARIANT_CLASS_INT16,
            Self::Uint16 => ffi::G_VARIANT_CLASS_UINT16,
            Self::Int32 => ffi::G_VARIANT_CLASS_INT32,
            Self::Uint32 => ffi::G_VARIANT_CLASS_UINT32,
            Self::Int64 => ffi::G_VARIANT_CLASS_INT64,
            Self::Uint64 => ffi::G_VARIANT_CLASS_UINT64,
            Self::Handle => ffi::G_VARIANT_CLASS_HANDLE,
            Self::Double => ffi::G_VARIANT_CLASS_DOUBLE,
            Self::String => ffi::G_VARIANT_CLASS_STRING,
            Self::ObjectPath => ffi::G_VARIANT_CLASS_OBJECT_PATH,
            Self::Signature => ffi::G_VARIANT_CLASS_SIGNATURE,
            Self::Variant => ffi::G_VARIANT_CLASS_VARIANT,
            Self::Maybe => ffi::G_VARIANT_CLASS_MAYBE,
            Self::Array => ffi::G_VARIANT_CLASS_ARRAY,
            Self::Tuple => ffi::G_VARIANT_CLASS_TUPLE,
            Self::DictEntry => ffi::G_VARIANT_CLASS_DICT_ENTRY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::GVariantClass> for VariantClass {
    unsafe fn from_glib(value: ffi::GVariantClass) -> Self {
        match value {
            ffi::G_VARIANT_CLASS_BOOLEAN => Self::Boolean,
            ffi::G_VARIANT_CLASS_BYTE => Self::Byte,
            ffi::G_VARIANT_CLASS_INT16 => Self::Int16,
            ffi::G_VARIANT_CLASS_UINT16 => Self::Uint16,
            ffi::G_VARIANT_CLASS_INT32 => Self::Int32,
            ffi::G_VARIANT_CLASS_UINT32 => Self::Uint32,
            ffi::G_VARIANT_CLASS_INT64 => Self::Int64,
            ffi::G_VARIANT_CLASS_UINT64 => Self::Uint64,
            ffi::G_VARIANT_CLASS_HANDLE => Self::Handle,
            ffi::G_VARIANT_CLASS_DOUBLE => Self::Double,
            ffi::G_VARIANT_CLASS_STRING => Self::String,
            ffi::G_VARIANT_CLASS_OBJECT_PATH => Self::ObjectPath,
            ffi::G_VARIANT_CLASS_SIGNATURE => Self::Signature,
            ffi::G_VARIANT_CLASS_VARIANT => Self::Variant,
            ffi::G_VARIANT_CLASS_MAYBE => Self::Maybe,
            ffi::G_VARIANT_CLASS_ARRAY => Self::Array,
            ffi::G_VARIANT_CLASS_TUPLE => Self::Tuple,
            ffi::G_VARIANT_CLASS_DICT_ENTRY => Self::DictEntry,
            value => Self::__Unknown(value),
        }
    }
}
