// -*- C++ -*- (c) 2005-2008 Peter Rockai <me@mornfall.net>

#include <adept/config.h>
#ifndef RPM
#ifndef EPT_DPKGPM_H
#  define EPT_DPKGPM_H

#include <apt-pkg/debsystem.h>
#include <adept/dpkgpm.h>
#include <adept/debconf.h>

#include <kde_terminal_interface.h>
#include <kprocess.h>

class KListBox;
namespace KParts {
class Part;
}

namespace adept {
using namespace ept::core;

class DpkgGui : public QObject, public DpkgHarness
{
    Q_OBJECT
    DebconfFrontend *m_dcf;
public:
    DpkgGui( package::Source &s )
        : DpkgHarness( s )
    {}
    virtual void dpkgMonitor( void );
    virtual void updateStatus( std::string pkg, std::string ev, std::string r );
    virtual void handleConffile( std::string file,
                                 std::string u, std::string s );
    virtual void setDebconf( DebconfFrontend *dcf ) {
        m_dcf = dcf;
    }

signals:
    void statusChanged( int p, QString m );
    void conffilePrompt( std::string, std::string, std::string );
};

typedef DPkgPM< DpkgGui > GuiDPkgPM;

}

#endif
#endif
