/* -*- C++ -*- */
#ifndef TESTUI_APP_H
#define TESTUI_APP_H

#define KUBUNTU

#include <kmainwindow.h>
#include <kparts/part.h>
#include <kactionclasses.h>
#include <apt-front/cache/observer.h>
#include <apt-front/cache/component/state.h>
#include <apt-front/cache/component/history.h>
#include <adept/view.h>
#include <adept/commitprogress.h>
#include <adept/application.h>

#ifdef KUBUNTU
#include <kubuntu_upgrader/upgradewizard.h>
#endif

class QVBox;
class QWidgetStack;
class QSplitter;
class KAction;
class KPushButton;
namespace adept {
class AcqProgressWidget;
}

using namespace aptFront;
using namespace adept;

class TestApp : public KMainWindow, Application {
    Q_OBJECT
public:
    void setupActions();
    ExtTerminalInterface *terminal();
	TestApp();
protected slots:
    void start();
    void update();
    void postUpdate();
    void commit();

    void delayed();

    void undo() { Application::undo(); }
    void redo() { Application::redo(); }
    void checkpoint() { Application::checkpoint(); }

    void setHistoryEnabled( bool );

    void disableNext();
    void disableButtons();
    void setNext( QString str, const char *slot,
                  QString qstr = i18n( "Forget Changes and Quit" ),
                  const char *qslot = SLOT( close() ) );
#ifdef KUBUNTU
    void releaseUpgrade();
#endif
protected:
    friend class WaitForLister;

    virtual void notifyPostChange( cache::component::Base * );
    virtual void notifyPreChange( cache::component::Base * );

    QWidgetStack *m_stack;
    QVBox *m_all;
    QHBox *m_buttons;
    QLabel *m_start, *m_bye, *m_loading;
    KPushButton *m_next, *m_quit;

    // stacked widgets
    adept::AcqProgressWidget *m_progress;
    adept::CommitProgress *m_commitProgress;
    adept::Browser *m_list;

    // other stuff
    std::vector<KAction *> m_actions;
    QMap< QString, QString > m_icons;
    KAction *m_undo, *m_redo;
    cache::component::History< cache::component::State > *m_history;

#ifdef KUBUNTU
    UpgradeWizard* wizard;
#endif
};

class WaitForLister : public QObject {
    Q_OBJECT
public:
    WaitForLister( TestApp *a, const char *s )
        : app( a ), slot( s )
        {
            waiting();
        }
protected slots:
    void waiting();
protected:
    TestApp *app;
    const char *slot;

};

#endif
